/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.locale;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.sf.okapi.steps.tokenization.locale.LocaleUtil;

public class LanguageList {
    private static TreeMap<String, ULocale> map;
    private static final ULocale EN;

    protected static String formatLanguageInfo(ULocale locale) {
        if (locale == null) {
            return "";
        }
        return locale.getDisplayName(EN);
    }

    public static String[] getLanguages() {
        ArrayList<String> res = new ArrayList<String>();
        for (ULocale locale : map.values()) {
            res.add(LanguageList.formatLanguageInfo(locale));
        }
        return res.toArray(new String[0]);
    }

    public static List<String> getAllLanguages() {
        ArrayList<String> res = new ArrayList<String>();
        for (ULocale locale : map.values()) {
            res.add(LocaleUtil.normalizeLanguageCode_Okapi(locale.getName()));
        }
        return res;
    }

    public static String[] getLanguageCodes_Okapi() {
        List<String> res = LanguageList.getAllLanguages();
        if (res == null) {
            return new String[0];
        }
        return res.toArray(new String[0]);
    }

    public static String[] getLanguageCodes_ICU() {
        ArrayList<String> res = new ArrayList<String>();
        for (ULocale locale : map.values()) {
            res.add(locale.getName());
        }
        return res.toArray(new String[0]);
    }

    public static String getDisplayName(String code_Okapi) {
        String code_ICU = LocaleUtil.normalizeLanguageCode_ICU(code_Okapi);
        return LanguageList.formatLanguageInfo(map.get(code_ICU));
    }

    static {
        ULocale[] locales;
        map = new TreeMap();
        EN = new ULocale("en");
        for (ULocale locale : locales = ULocale.getAvailableLocales()) {
            if (locale == null) continue;
            map.put(locale.getName(), locale);
        }
    }
}

