/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.repetitionanalysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.steps.repetitionanalysis.SegmentInfo;
import net.sf.okapi.tm.pensieve.common.TmHit;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;

public class RepetitiveSegmentAnnotation
implements IAnnotation {
    private SegmentInfo info;
    private Map<SegmentInfo, Float> map;

    public RepetitiveSegmentAnnotation(SegmentInfo info, Map<SegmentInfo, Float> map) {
        this.info = info;
        this.map = map;
    }

    public RepetitiveSegmentAnnotation(SegmentInfo info, List<TmHit> hits) {
        this.info = info;
        this.map = new HashMap<SegmentInfo, Float>();
        if (hits == null) {
            return;
        }
        for (TmHit hit : hits) {
            TranslationUnit hitTu = hit.getTu();
            this.map.put(new SegmentInfo(hitTu.getMetadata()), Float.valueOf(hit.getScore()));
        }
    }

    public Map<SegmentInfo, Float> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public void setMap(Map<SegmentInfo, Float> map) {
        this.map = map;
    }

    public SegmentInfo getInfo() {
        return this.info;
    }

    public void setInfo(SegmentInfo info) {
        this.info = info;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SegmentInfo refInfo : this.map.keySet()) {
            sb.append(String.format(", %s - %3.2f", refInfo.getTuid(), this.map.get(refInfo)));
        }
        return String.format("(tuid: %s groupId: %s segId: %s)%s", this.info.getTuid(), this.info.getGroupId(), this.info.getSegId(), sb.toString());
    }
}

