/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.enrycher;

import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.steps.enrycher.EnrycherClient;
import net.sf.okapi.steps.enrycher.Parameters;

@UsingParameters(value=Parameters.class)
public class EnrycherStep
extends BasePipelineStep {
    private LinkedList<Event> events;
    private int maxEvents;
    private boolean needReset;
    private EnrycherClient client = new EnrycherClient();

    private void closeAndClean() {
        if (this.events != null) {
            this.events.clear();
            this.events = null;
        }
    }

    @Override
    public String getName() {
        return "Enrycher";
    }

    @Override
    public String getDescription() {
        return "Applies Enrycher ITS annotations to the source content. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.client.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.client.setParameters((Parameters)params);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.events = new LinkedList();
        this.maxEvents = ((Parameters)this.client.getParameters()).getMaxEvents();
        if (this.maxEvents < 1 || this.maxEvents > 1000) {
            this.maxEvents = 20;
        }
        return event;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                return this.handleStartBatch(event);
            }
            case TEXT_UNIT: {
                return this.storeAndPossiblyProcess(event, false);
            }
            case DOCUMENT_PART: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: 
            case PIPELINE_PARAMETERS: {
                return this.storeAndPossiblyProcess(event, false);
            }
            case CUSTOM: 
            case MULTI_EVENT: 
            case START_SUBDOCUMENT: 
            case END_DOCUMENT: 
            case END_SUBDOCUMENT: {
                return this.storeAndPossiblyProcess(event, true);
            }
            case CANCELED: 
            case END_BATCH: {
                this.closeAndClean();
                break;
            }
            case START_BATCH_ITEM: 
            case END_BATCH_ITEM: 
            case RAW_DOCUMENT: 
            case START_DOCUMENT: {
                break;
            }
            case NO_OP: {
                break;
            }
        }
        return event;
    }

    private Event processEvents() {
        this.callService();
        this.needReset = true;
        return new Event(EventType.MULTI_EVENT, new MultiEvent(this.events));
    }

    private Event storeAndPossiblyProcess(Event event, boolean mustProcess) {
        if (this.needReset) {
            this.needReset = false;
            this.events.clear();
        }
        this.events.add(event);
        if (mustProcess || this.events.size() >= this.maxEvents) {
            return this.processEvents();
        }
        return Event.createNoopEvent();
    }

    private void callService() {
        if (this.events.isEmpty()) {
            return;
        }
        LinkedList<ITextUnit> list = new LinkedList<ITextUnit>();
        for (Event event : this.events) {
            if (!event.isTextUnit()) continue;
            list.add(event.getTextUnit());
        }
        this.client.processList(list);
    }
}

