/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final String MAXVALIDATION = "maxValidation";
    public static final String MERGE_AS_PARAGRAPH = "mergeAsParagraph";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String SIMPLIFY_TAGS = "simplifyTags";
    private static final String NEEDS_SEGMENTATION = "needsSegmentation";
    private InlineCodeFinder codeFinder;

    public boolean getMaxValidation() {
        return this.getBoolean(MAXVALIDATION);
    }

    public void setMaxValidation(boolean maxValidation) {
        this.setBoolean(MAXVALIDATION, maxValidation);
    }

    public boolean getMergeAsParagraph() {
        return this.getBoolean(MERGE_AS_PARAGRAPH);
    }

    public void setMergeAsParagraph(boolean mergeAsParagraph) {
        this.setBoolean(MERGE_AS_PARAGRAPH, mergeAsParagraph);
    }

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    public boolean getSimplifyTags() {
        return this.getBoolean(SIMPLIFY_TAGS);
    }

    public void setSimplifyTags(boolean simplifyTags) {
        this.setBoolean(SIMPLIFY_TAGS, simplifyTags);
    }

    public boolean getNeedsSegmentation() {
        return this.getBoolean(NEEDS_SEGMENTATION);
    }

    public void setNeedsSegmentation(boolean needsSegmentation) {
        this.setBoolean(NEEDS_SEGMENTATION, needsSegmentation);
    }

    @Override
    public void reset() {
        super.reset();
        this.setMaxValidation(true);
        this.setMergeAsParagraph(false);
        this.setUseCodeFinder(false);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("&name; <tag></at><tag/> <tag attr='val'> </tag=\"val\">");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("</?([A-Z0-9a-z]*)\\b[^>]*>");
        this.setSimplifyTags(true);
        this.setNeedsSegmentation(false);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(MAXVALIDATION, "Perform maximum validation when parsing", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("XLIFF-2 Filter Parameters", true, false);
        desc.addCheckboxPart(paramDesc.get(MAXVALIDATION));
        return desc;
    }
}

