/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tex.parser;

import java.util.Deque;
import java.util.LinkedList;
import net.sf.okapi.filters.tex.parser.TEXToken;
import net.sf.okapi.filters.tex.parser.TEXTokenType;

public class TEXParser {
    private String newline = System.lineSeparator();
    private Deque<TEXToken> tokenQueue = new LinkedList<TEXToken>();

    public TEXParser() {
    }

    public TEXParser(String newline) {
        this.newline = newline;
    }

    private CharType getCharType(String cc) {
        if (cc.equals("\\")) {
            return CharType.ESCAPE;
        }
        if (cc.equals("{")) {
            return CharType.START_GROUP;
        }
        if (cc.equals("}")) {
            return CharType.END_GROUP;
        }
        if (cc.equals("$")) {
            return CharType.MATH_SHIFT;
        }
        if (cc.equals("&")) {
            return CharType.ALIGN_TAB;
        }
        if (cc.matches("[\n]")) {
            return CharType.EOL;
        }
        if (cc.equals("#")) {
            return CharType.PARAM;
        }
        if (cc.equals("^")) {
            return CharType.SUPERSCRIPT;
        }
        if (cc.equals("_")) {
            return CharType.SUBSCRIPT;
        }
        if (cc.matches("[\r]")) {
            return CharType.IGNORED;
        }
        if (cc.matches("[ \t]")) {
            return CharType.WHITESPACE;
        }
        if (cc.matches("[a-zA-Z0-9]")) {
            return CharType.ALPHANUM;
        }
        if (cc.equals("~")) {
            return CharType.ACTIVE;
        }
        if (cc.equals("%")) {
            return CharType.COMMENT;
        }
        if (cc.equals("\u0000")) {
            return CharType.INVALID;
        }
        return CharType.DEFAULT;
    }

    public void parse(String content) {
        this.tokenQueue.clear();
        StringBuilder sb = new StringBuilder();
        StringBuilder comment = new StringBuilder();
        String[] chars = content.split("");
        for (int index = 0; index < chars.length; ++index) {
            String cc = chars[index];
            CharType type = this.getCharType(cc);
            if (type == CharType.ESCAPE) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                StringBuilder cmd = new StringBuilder();
                cmd.append(cc);
                ++index;
                while (index < chars.length) {
                    String cmdc = chars[index];
                    if (this.getCharType(cmdc) == CharType.ALPHANUM) {
                        cmd.append(cmdc);
                    } else if (this.getCharType(cmdc) == CharType.DEFAULT) {
                        cmd.append(cmdc);
                        if (cmdc.equals("[")) {
                            ++index;
                            while (index < chars.length) {
                                cmdc = chars[index];
                                if (this.getCharType(cmdc) == CharType.IGNORED) {
                                    ++index;
                                    continue;
                                }
                                if (cmdc.equals("]")) {
                                    cmd.append(cmdc);
                                    break;
                                }
                                cmd.append(cmdc);
                                ++index;
                            }
                        }
                    } else {
                        if (this.getCharType(cmdc) == CharType.IGNORED) {
                            ++index;
                            continue;
                        }
                        if (cmd.length() == 1) {
                            cmd.append(cmdc);
                            break;
                        }
                        if (this.getCharType(cmdc) == CharType.WHITESPACE) {
                            cmd.append(cmdc);
                            break;
                        }
                        --index;
                        break;
                    }
                    ++index;
                }
                this.tokenQueue.addLast(new TEXToken(cmd.toString(), false, TEXTokenType.COMMAND));
                continue;
            }
            if (type == CharType.START_GROUP) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("{", false, TEXTokenType.OPEN_CURLY));
                continue;
            }
            if (type == CharType.END_GROUP) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("}", false, TEXTokenType.CLOSE_CURLY));
                continue;
            }
            if (type == CharType.MATH_SHIFT) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("$", false, TEXTokenType.DOLLAR));
                continue;
            }
            if (type == CharType.ALIGN_TAB) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("&", false, TEXTokenType.AMPERSAND));
                continue;
            }
            if (type == CharType.EOL) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("\n", false, TEXTokenType.NEWLINE));
                continue;
            }
            if (type == CharType.PARAM) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("#", false, TEXTokenType.HASHTAG));
                continue;
            }
            if (type == CharType.SUPERSCRIPT) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("^", false, TEXTokenType.CARET));
                continue;
            }
            if (type == CharType.SUBSCRIPT) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("_", false, TEXTokenType.UNDERSCORE));
                continue;
            }
            if (type == CharType.IGNORED) continue;
            if (type == CharType.WHITESPACE) {
                sb.append(cc);
                continue;
            }
            if (type == CharType.ALPHANUM) {
                sb.append(cc);
                continue;
            }
            if (type == CharType.ACTIVE) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("~", false, TEXTokenType.TILDE));
                continue;
            }
            if (type == CharType.COMMENT) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                comment.setLength(0);
                comment.append(cc);
                ++index;
                while (index < chars.length && this.getCharType(chars[index]) != CharType.EOL) {
                    if (this.getCharType(chars[index]) == CharType.IGNORED) {
                        ++index;
                        continue;
                    }
                    String commentc = chars[index];
                    comment.append(commentc);
                    ++index;
                }
                this.tokenQueue.addLast(new TEXToken(comment.toString(), false, TEXTokenType.COMMENT));
                if (index >= chars.length) continue;
                this.tokenQueue.addLast(new TEXToken(chars[index], false, TEXTokenType.NEWLINE));
                continue;
            }
            if (type == CharType.INVALID) {
                if (sb.length() > 0) {
                    this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
                    sb.setLength(0);
                }
                this.tokenQueue.addLast(new TEXToken("\u0000", false, TEXTokenType.INVALID_CHAR));
                continue;
            }
            sb.append(cc);
        }
        if (sb.length() > 0) {
            this.tokenQueue.addLast(new TEXToken(sb.toString(), true, TEXTokenType.TEXT));
        }
    }

    public boolean hasNextToken() {
        return !this.tokenQueue.isEmpty();
    }

    public TEXToken getNextToken() {
        if (!this.hasNextToken()) {
            throw new IllegalStateException("No more tokens remaining");
        }
        return this.tokenQueue.removeFirst();
    }

    public TEXToken peekNextToken() {
        return this.tokenQueue.peekFirst();
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public static enum CharType {
        ESCAPE,
        START_GROUP,
        END_GROUP,
        MATH_SHIFT,
        ALIGN_TAB,
        EOL,
        PARAM,
        SUPERSCRIPT,
        SUBSCRIPT,
        WHITESPACE,
        ALPHANUM,
        DEFAULT,
        ACTIVE,
        COMMENT,
        IGNORED,
        INVALID;

    }
}

