/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunBuilderSkipper;
import net.sf.okapi.filters.openxml.RunMerger;
import net.sf.okapi.filters.openxml.RunParser;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.Text;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

final class StringItemParser
implements Parser<StringItem> {
    private final StartElementContext startElementContext;
    private final IdGenerator nestedBlockIdGenerator;
    private final StyleDefinitions styleDefinitions;
    private final StyleOptimisation styleOptimisation;
    private final RunBuilderSkipper runBuilderSkipper;
    private StringItem.Builder builder;
    private SkippableElements phoneticRunAndPropertySkippableElements;

    StringItemParser(StartElementContext startElementContext, IdGenerator nestedBlockIdGenerator, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation) {
        this.startElementContext = startElementContext;
        this.nestedBlockIdGenerator = nestedBlockIdGenerator;
        this.styleDefinitions = styleDefinitions;
        this.styleOptimisation = styleOptimisation;
        this.builder = new StringItem.Builder();
        this.runBuilderSkipper = new RunBuilderSkipper();
        this.phoneticRunAndPropertySkippableElements = new SkippableElements.Inline(new SkippableElements.Default(SkippableElement.PhoneticInline.PHONETIC_RUN, SkippableElement.PhoneticInline.PHONETIC_PROPERTY));
    }

    @Override
    public StringItem parse() throws XMLStreamException {
        XMLEvent e;
        this.builder.addToMarkup(MarkupComponentFactory.createStartMarkupComponent(this.startElementContext.getEventFactory(), this.startElementContext.getStartElement()));
        RunMerger runMerger = new RunMerger();
        do {
            if (XMLEventHelpers.isRunStartEvent(e = this.startElementContext.getEventReader().nextEvent())) {
                this.processRun(this.builder, runMerger, e.asStartElement());
                continue;
            }
            if (XMLEventHelpers.isTextStartEvent(e)) {
                this.addRunsToBuilder(this.builder, runMerger);
                this.processText(e.asStartElement(), this.builder);
                continue;
            }
            if (e.isStartElement() && this.phoneticRunAndPropertySkippableElements.canBeSkipped(e.asStartElement(), this.startElementContext.getStartElement())) {
                this.phoneticRunAndPropertySkippableElements.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext));
                continue;
            }
            if (XMLEventHelpers.isWhitespace(e)) continue;
            this.addRunsToBuilder(this.builder, runMerger);
            if (e.isEndElement() && this.startElementContext.getStartElement().getName().equals(e.asEndElement().getName())) {
                this.builder.addToMarkup(MarkupComponentFactory.createEndMarkupComponent(e.asEndElement()));
                this.builder.styleOptimisation(this.styleOptimisation);
                return this.builder.build();
            }
            this.builder.addToMarkup(e);
        } while (this.startElementContext.getEventReader().hasNext() && !XMLEventHelpers.isStringItemEndEvent(e));
        throw new IllegalStateException("Invalid content? Unterminated string item");
    }

    private void processRun(StringItem.Builder builder, RunMerger runMerger, StartElement startEl) throws XMLStreamException {
        StartElementContext runElementContext = StartElementContextFactory.createStartElementContext(startEl, this.startElementContext);
        RunBuilder runBuilder = new RunParser(runElementContext, this.nestedBlockIdGenerator, this.styleDefinitions, this.styleOptimisation, null, false).parse();
        if (this.runBuilderSkipper.canSkip(runBuilder)) {
            return;
        }
        builder.runName(startEl.getName());
        builder.textName(runBuilder.getTextName());
        runMerger.add(runBuilder);
    }

    private void processText(StartElement startElement, StringItem.Builder builder) throws XMLStreamException {
        EndElement endElement;
        Characters characters;
        XMLEvent event = this.startElementContext.getEventReader().nextEvent();
        if (event.isEndElement()) {
            characters = this.startElementContext.getEventFactory().createCharacters("");
            endElement = event.asEndElement();
        } else {
            characters = event.asCharacters();
            endElement = this.startElementContext.getEventReader().nextEvent().asEndElement();
        }
        Text text = new Text(startElement, characters, endElement);
        builder.addChunk(text);
    }

    private void addRunsToBuilder(StringItem.Builder builder, RunMerger runMerger) throws XMLStreamException {
        for (Block.BlockChunk chunk : runMerger.getRuns()) {
            builder.addChunk(chunk);
        }
        runMerger.reset();
    }
}

