/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MergeableRunProperty;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.SchemaDefinition;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

abstract class RunProperties
implements MarkupComponent {
    static final String RPR = "rPr";
    static final String DEF_RPR = "defRPr";

    RunProperties() {
    }

    abstract List<RunProperty> getProperties();

    public int count() {
        return this.getProperties().size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof RunProperties)) {
            return false;
        }
        return this.equalsProperties((RunProperties)o);
    }

    protected abstract boolean equalsProperties(RunProperties var1);

    public abstract int hashCode();

    @Override
    public abstract List<XMLEvent> getEvents();

    public abstract RunProperties combineDistinct(RunProperties var1, StyleDefinitions.TraversalStage var2);

    boolean isPresent(String name) {
        for (RunProperty property : this.getProperties()) {
            if (!property.getName().getLocalPart().equals(name)) continue;
            return true;
        }
        return false;
    }

    RunProperty.RunStyleProperty getRunStyleProperty() {
        for (RunProperty property : this.getProperties()) {
            if (!(property instanceof RunProperty.RunStyleProperty)) continue;
            return (RunProperty.RunStyleProperty)property;
        }
        return null;
    }

    RunProperty.RunHighlightProperty getHighlightProperty() {
        for (RunProperty property : this.getProperties()) {
            if (!(property instanceof RunProperty.RunHighlightProperty)) continue;
            return (RunProperty.RunHighlightProperty)property;
        }
        return null;
    }

    RunProperty.RunColorProperty getRunColorProperty() {
        for (RunProperty property : this.getProperties()) {
            if (!(property instanceof RunProperty.RunColorProperty)) continue;
            return (RunProperty.RunColorProperty)property;
        }
        return null;
    }

    List<RunProperty> getMergeableRunProperties() {
        ArrayList<RunProperty> properties = new ArrayList<RunProperty>(this.getProperties().size());
        for (RunProperty property : this.getProperties()) {
            if (!(property instanceof MergeableRunProperty)) continue;
            properties.add(property);
        }
        return properties;
    }

    List<RunProperty> attributeRunProperties() {
        return this.getProperties().stream().filter(runProperty -> runProperty instanceof RunProperty.AttributeRunProperty).collect(Collectors.toList());
    }

    void refine(List<RunProperty> commonRunProperties) {
        for (RunProperty commonRunProperty : commonRunProperties) {
            this.updateOrAdd(commonRunProperty);
        }
    }

    private void updateOrAdd(RunProperty commonRunProperty) {
        ListIterator<RunProperty> iterator = this.getProperties().listIterator();
        while (iterator.hasNext()) {
            RunProperty currentRunProperty = iterator.next();
            if (!currentRunProperty.getName().equals(commonRunProperty.getName())) continue;
            iterator.set(commonRunProperty);
            return;
        }
        iterator.add(commonRunProperty);
    }

    void alignWith(SchemaDefinition.Component schemaDefinition) {
        if (this.getProperties().isEmpty()) {
            return;
        }
        ArrayList<RunProperty> copiedProperties = new ArrayList<RunProperty>(this.getProperties());
        List<RunProperty> attributeRunProperties = this.attributeRunProperties();
        this.getProperties().retainAll(attributeRunProperties);
        copiedProperties.removeAll(attributeRunProperties);
        ListIterator<SchemaDefinition.Component> iterator = schemaDefinition.listIterator();
        while (iterator.hasNext() || !copiedProperties.isEmpty()) {
            SchemaDefinition.Component component = iterator.next();
            switch (component.composition()) {
                case CHOICE: 
                case SEQUENCE: 
                case ALL: {
                    this.findAndAppendMany(copiedProperties, component);
                    break;
                }
                case NONE: {
                    this.findAndAppendOne(copiedProperties, component);
                }
            }
        }
    }

    private void findAndAppendMany(List<RunProperty> copiedProperties, SchemaDefinition.Component component) {
        ListIterator<SchemaDefinition.Component> componentsIterator = component.listIterator();
        while (componentsIterator.hasNext()) {
            SchemaDefinition.Component innerComponent = (SchemaDefinition.Component)componentsIterator.next();
            switch (innerComponent.composition()) {
                case CHOICE: 
                case SEQUENCE: 
                case ALL: {
                    this.findAndAppendMany(copiedProperties, innerComponent);
                    break;
                }
                case NONE: {
                    this.findAndAppendOne(copiedProperties, innerComponent);
                }
            }
        }
    }

    private void findAndAppendOne(List<RunProperty> copiedProperties, SchemaDefinition.Component component) {
        Iterator<RunProperty> copiedPropertiesIterator = copiedProperties.iterator();
        while (copiedPropertiesIterator.hasNext()) {
            RunProperty runProperty = copiedPropertiesIterator.next();
            if (!runProperty.getName().equals(component.name())) continue;
            this.getProperties().add(runProperty);
            copiedPropertiesIterator.remove();
            return;
        }
    }

    void remove(RunProperty runProperty) {
        Iterator<RunProperty> propertiesIterator = this.getProperties().iterator();
        while (propertiesIterator.hasNext()) {
            RunProperty currentRunProperty = propertiesIterator.next();
            if (!currentRunProperty.getName().equals(runProperty.getName())) continue;
            propertiesIterator.remove();
            return;
        }
    }

    static RunProperties copiedRunProperties(RunProperties existingProperties, boolean stripVerticalAlign, boolean stripRunStyle, boolean stripToggle) {
        if (existingProperties instanceof Empty) {
            return existingProperties;
        }
        ArrayList<RunProperty> newRunProperties = new ArrayList<RunProperty>();
        for (RunProperty p : existingProperties.getProperties()) {
            if (stripToggle && p instanceof RunProperty.WpmlToggleRunProperty || stripRunStyle && p instanceof RunProperty.RunStyleProperty || stripVerticalAlign && p instanceof RunProperty.GenericRunProperty && (SkippableElement.RunProperty.RUN_PROPERTY_VERTICAL_ALIGNMENT_WPML.toName().equals(p.getName()) || SkippableElement.RunProperty.RUN_PROPERTY_VERTICAL_ALIGNMENT_SSML.toName().equals(p.getName()))) continue;
            newRunProperties.add(p);
        }
        return new Default(((Default)existingProperties).eventFactory, ((Default)existingProperties).startElement, ((Default)existingProperties).endElement, newRunProperties);
    }

    static RunProperties copiedRunProperties(RunProperties runProperties) {
        if (runProperties instanceof Empty) {
            return runProperties;
        }
        ArrayList<RunProperty> properties = new ArrayList<RunProperty>(runProperties.getProperties());
        return new Default(((Default)runProperties).eventFactory, ((Default)runProperties).startElement, ((Default)runProperties).endElement, properties);
    }

    static RunProperties copiedToggleRunProperties(RunProperties runProperties) {
        if (runProperties instanceof Empty) {
            return runProperties;
        }
        ArrayList<RunProperty> properties = new ArrayList<RunProperty>(runProperties.count());
        for (RunProperty property : runProperties.getProperties()) {
            if (!(property instanceof RunProperty.WpmlToggleRunProperty)) continue;
            properties.add(property);
        }
        return new Default(((Default)runProperties).eventFactory, ((Default)runProperties).startElement, ((Default)runProperties).endElement, properties);
    }

    static RunProperties emptyRunProperties() {
        return new Empty();
    }

    static RunProperties defaultRunProperties(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement, RunProperty ... properties) {
        return new Default(eventFactory, startElement, endElement, new ArrayList<RunProperty>(Arrays.asList(properties)));
    }

    boolean isSubsetOf(RunProperties other) {
        if (this.getProperties().isEmpty() && !other.getProperties().isEmpty()) {
            return false;
        }
        block0: for (RunProperty myProperty : this.getProperties()) {
            for (RunProperty otherProperty : other.getProperties()) {
                if (!otherProperty.equalsProperty(myProperty)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    static class Default
    extends RunProperties
    implements Nameable {
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private final EndElement endElement;
        private final List<RunProperty> properties;

        Default(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement, List<RunProperty> properties) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.endElement = endElement;
            this.properties = properties;
        }

        @Override
        public List<RunProperty> getProperties() {
            return this.properties;
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            List<RunProperty> attributeRunProperties = this.attributeRunProperties();
            List otherRunProperties = this.properties.stream().filter(runProperty -> !attributeRunProperties.contains(runProperty)).collect(Collectors.toList());
            events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.toAttributes(this.attributeRunProperties()).iterator(), this.startElement.getNamespaces()));
            for (RunProperty property : otherRunProperties) {
                events.addAll(property.getEvents());
            }
            events.add(this.endElement);
            return events;
        }

        private List<Attribute> toAttributes(List<RunProperty> properties) {
            return properties.stream().map(property -> this.eventFactory.createAttribute(property.getName(), property.getValue())).collect(Collectors.toList());
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        @Override
        public RunProperties combineDistinct(RunProperties otherProperties, StyleDefinitions.TraversalStage traversalStage) {
            ListIterator<RunProperty> runPropertyIterator = this.properties.listIterator();
            while (runPropertyIterator.hasNext()) {
                RunProperty runProperty = runPropertyIterator.next();
                QName runPropertyStartElementName = runProperty.getName();
                Iterator<RunProperty> otherRunPropertyIterator = otherProperties.getProperties().iterator();
                while (otherRunPropertyIterator.hasNext()) {
                    RunProperty otherRunProperty = otherRunPropertyIterator.next();
                    if (!runPropertyStartElementName.equals(otherRunProperty.getName())) continue;
                    this.replace(runPropertyIterator, otherRunPropertyIterator, runProperty, otherRunProperty, traversalStage);
                    break;
                }
                if (!otherProperties.getProperties().isEmpty()) continue;
                break;
            }
            if (!otherProperties.getProperties().isEmpty()) {
                this.properties.addAll(otherProperties.getProperties());
            }
            return this;
        }

        private void replace(ListIterator<RunProperty> runPropertyIterator, Iterator<RunProperty> otherRunPropertyIterator, RunProperty runProperty, RunProperty otherRunProperty, StyleDefinitions.TraversalStage traversalStage) {
            if (runProperty instanceof RunProperty.WpmlToggleRunProperty) {
                boolean otherRunPropertyValue;
                boolean runPropertyValue;
                if (StyleDefinitions.TraversalStage.VERTICAL == traversalStage) {
                    runPropertyValue = ((RunProperty.WpmlToggleRunProperty)runProperty).getToggleValue();
                    if (!(runPropertyValue ^ (otherRunPropertyValue = ((RunProperty.WpmlToggleRunProperty)otherRunProperty).getToggleValue()))) {
                        runPropertyIterator.remove();
                        otherRunPropertyIterator.remove();
                        return;
                    }
                    if (runPropertyValue) {
                        otherRunPropertyIterator.remove();
                        return;
                    }
                }
                if (StyleDefinitions.TraversalStage.DOCUMENT_DEFAULT == traversalStage) {
                    runPropertyValue = ((RunProperty.WpmlToggleRunProperty)runProperty).getToggleValue();
                    otherRunPropertyValue = ((RunProperty.WpmlToggleRunProperty)otherRunProperty).getToggleValue();
                    if (runPropertyValue && otherRunPropertyValue || runPropertyValue) {
                        otherRunPropertyIterator.remove();
                        return;
                    }
                }
            }
            runPropertyIterator.set(otherRunProperty);
            otherRunPropertyIterator.remove();
        }

        @Override
        protected boolean equalsProperties(RunProperties o) {
            if (o instanceof Empty) {
                return this.count() == o.count();
            }
            if (!(o instanceof Default)) {
                return false;
            }
            Default rp = (Default)o;
            if (!XMLEventHelpers.startElementEquals(this.startElement, rp.startElement)) {
                return false;
            }
            return this.properties.equals(rp.properties);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.startElement, this.endElement, this.properties);
        }

        public String toString() {
            return "rPr(" + this.properties.size() + ")[" + this.properties + "]";
        }
    }

    static class Empty
    extends RunProperties {
        Empty() {
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        protected boolean equalsProperties(RunProperties rp) {
            if (rp instanceof Default) {
                return this.count() == rp.count();
            }
            return rp instanceof Empty;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.emptyList();
        }

        @Override
        public List<RunProperty> getProperties() {
            return Collections.emptyList();
        }

        @Override
        public RunProperties combineDistinct(RunProperties otherProperties, StyleDefinitions.TraversalStage traversalStage) {
            return otherProperties;
        }

        public String toString() {
            return "(No properties)";
        }
    }
}

