/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.Markup;

class MarkupZipSkeleton
extends ZipSkeleton {
    private final XMLOutputFactory outputFactory;
    private final String encoding;
    private final Markup markup;

    MarkupZipSkeleton(ZipFile original, ZipEntry entry, XMLOutputFactory outputFactory, String encoding, Markup markup) {
        super(original, entry);
        this.outputFactory = outputFactory;
        this.encoding = encoding;
        this.markup = markup;
    }

    Markup getMarkup() {
        return this.markup;
    }

    @Override
    public String getModifiedContents() {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XMLEventWriter writer = this.outputFactory.createXMLEventWriter(outputStream);
            for (XMLEvent event : this.markup.getEvents()) {
                writer.add(event);
            }
            writer.close();
            return outputStream.toString(this.encoding);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Markup writing failed", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected encoding provided: ".concat(this.encoding), e);
        }
    }
}

