/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyleDefinitions;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;

class StoryChildElementsWriter {
    private final StyleRangeEventsGenerator styleRangeEventsGenerator;
    private StyleDefinitions currentStyleDefinitions;

    StoryChildElementsWriter(StyleRangeEventsGenerator styleRangeEventsGenerator) {
        this.styleRangeEventsGenerator = styleRangeEventsGenerator;
    }

    List<XMLEvent> write(List<StoryChildElement> storyChildElements) {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        for (StoryChildElement storyChildElement : storyChildElements) {
            if (!(storyChildElement instanceof StoryChildElement.StyledTextElement)) {
                if (null != this.currentStyleDefinitions) {
                    events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
                    events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeEnd());
                }
                events.addAll(storyChildElement.getEvents());
                if (null == this.currentStyleDefinitions) continue;
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeStart(this.currentStyleDefinitions));
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleDefinitions));
                continue;
            }
            if (null == this.currentStyleDefinitions) {
                this.currentStyleDefinitions = ((StoryChildElement.StyledTextElement)storyChildElement).getStyleDefinitions();
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeStart(this.currentStyleDefinitions));
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleDefinitions));
            }
            StyleDefinitions styleDefinitions = ((StoryChildElement.StyledTextElement)storyChildElement).getStyleDefinitions();
            if (!this.currentStyleDefinitions.getParagraphStyleRange().equals(styleDefinitions.getParagraphStyleRange())) {
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeEnd());
                this.currentStyleDefinitions = styleDefinitions;
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeStart(this.currentStyleDefinitions));
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleDefinitions));
                events.addAll(storyChildElement.getEvents());
                continue;
            }
            if (!this.currentStyleDefinitions.getCharacterStyleRange().equals(styleDefinitions.getCharacterStyleRange())) {
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
                this.currentStyleDefinitions = styleDefinitions;
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeStart(this.currentStyleDefinitions));
                events.addAll(storyChildElement.getEvents());
                continue;
            }
            events.addAll(storyChildElement.getEvents());
        }
        return events;
    }
}

