/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.StoryChildElementsWriter;
import net.sf.okapi.filters.idml.StyleDefinitions;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;

class StoryChildElement
extends MarkupRange.MarkupRangeElement {
    StoryChildElement(StartElement startElement, List<XMLEvent> events, EndElement endElement) {
        super(startElement, events, endElement);
    }

    static class StyledTextReferenceElement
    extends StyledTextElement {
        protected final Properties properties;
        protected final List<StoryChildElement> storyChildElements;
        protected final StyleRangeEventsGenerator styleRangeEventsGenerator;
        protected final StoryChildElementsWriter storyChildElementsWriter;

        StyledTextReferenceElement(StartElement startElement, Properties properties, List<StoryChildElement> storyChildElements, EndElement endElement, StyleDefinitions styleDefinitions, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
            super(startElement, Collections.emptyList(), endElement, styleDefinitions);
            this.properties = properties;
            this.storyChildElements = storyChildElements;
            this.styleRangeEventsGenerator = styleRangeEventsGenerator;
            this.storyChildElementsWriter = storyChildElementsWriter;
        }

        Properties getProperties() {
            return this.properties;
        }

        List<StoryChildElement> getStoryChildElements() {
            return this.storyChildElements;
        }

        @Override
        StyledTextReferenceElement copyWith(StyleDefinitions styleDefinitions) {
            return new StyledTextReferenceElement(this.getStartElement(), this.properties, this.storyChildElements, this.getEndElement(), styleDefinitions, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.getStartElement());
            events.addAll(this.properties.getEvents());
            events.addAll(this.storyChildElementsWriter.write(this.storyChildElements));
            if (!this.storyChildElements.isEmpty() && this.storyChildElements.get(this.storyChildElements.size() - 1) instanceof StyledTextElement) {
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeEnd());
            }
            events.add(this.getEndElement());
            return events;
        }

        static class Table
        extends StyledTextReferenceElement {
            private final List<MarkupRange.MarkupRangeElement> markupRangeElements;
            private final List<Cell> cells;

            Table(StartElement startElement, Properties properties, List<MarkupRange.MarkupRangeElement> markupRangeElements, List<Cell> cells, EndElement endElement, StyleDefinitions styleDefinitions) {
                super(startElement, properties, Collections.emptyList(), endElement, styleDefinitions, null, null);
                this.markupRangeElements = markupRangeElements;
                this.cells = cells;
            }

            List<Cell> getCells() {
                return this.cells;
            }

            @Override
            Table copyWith(StyleDefinitions styleDefinitions) {
                return new Table(this.getStartElement(), this.properties, this.markupRangeElements, this.cells, this.getEndElement(), styleDefinitions);
            }

            @Override
            public List<XMLEvent> getEvents() {
                ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
                events.add(this.getStartElement());
                events.addAll(this.properties.getEvents());
                for (MarkupRange.MarkupRangeElement markupRangeElement : this.markupRangeElements) {
                    events.addAll(markupRangeElement.getEvents());
                }
                for (Cell cell : this.cells) {
                    events.addAll(cell.getEvents());
                }
                events.add(this.getEndElement());
                return events;
            }

            static class Cell
            extends StyledTextReferenceElement {
                Cell(StartElement startElement, List<StoryChildElement> storyChildElements, EndElement endElement, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
                    super(startElement, Properties.getEmptyProperties(), storyChildElements, endElement, null, styleRangeEventsGenerator, storyChildElementsWriter);
                }

                @Override
                Cell copyWith(StyleDefinitions styleDefinitions) {
                    return new Cell(this.getStartElement(), this.getStoryChildElements(), this.getEndElement(), this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                }

                static class CellBuilder
                extends StyledTextReferenceElementBuilder {
                    CellBuilder() {
                    }

                    @Override
                    public Cell build() {
                        return new Cell(this.startElement, this.storyChildElements, this.endElement, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                    }
                }
            }

            static class TableBuilder
            extends StyledTextReferenceElementBuilder {
                private List<MarkupRange.MarkupRangeElement> markupRangeElements = new ArrayList<MarkupRange.MarkupRangeElement>();
                private List<Cell> cells = new ArrayList<Cell>();

                TableBuilder() {
                }

                TableBuilder addMarkupRangeElement(MarkupRange.MarkupRangeElement markupRangeElement) {
                    this.markupRangeElements.add(markupRangeElement);
                    return this;
                }

                TableBuilder addCell(Cell cell) {
                    this.cells.add(cell);
                    return this;
                }

                @Override
                public Table build() {
                    return new Table(this.startElement, this.properties, this.markupRangeElements, this.cells, this.endElement, this.styleDefinitions);
                }
            }
        }

        static class Footnote
        extends StyledTextReferenceElement {
            Footnote(StartElement startElement, Properties properties, List<StoryChildElement> storyChildElements, EndElement endElement, StyleDefinitions styleDefinitions, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
                super(startElement, properties, storyChildElements, endElement, styleDefinitions, styleRangeEventsGenerator, storyChildElementsWriter);
            }

            @Override
            Footnote copyWith(StyleDefinitions styleDefinitions) {
                return new Footnote(this.getStartElement(), this.properties, this.storyChildElements, this.getEndElement(), styleDefinitions, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
            }

            static class FootnoteBuilder
            extends StyledTextReferenceElementBuilder {
                FootnoteBuilder() {
                }

                @Override
                public StyledTextReferenceElement build() {
                    return new Footnote(this.startElement, this.properties, this.storyChildElements, this.endElement, this.styleDefinitions, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                }
            }
        }

        static class Note
        extends StyledTextReferenceElement {
            Note(StartElement startElement, Properties properties, List<StoryChildElement> storyChildElements, EndElement endElement, StyleDefinitions styleDefinitions, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
                super(startElement, properties, storyChildElements, endElement, styleDefinitions, styleRangeEventsGenerator, storyChildElementsWriter);
            }

            @Override
            Note copyWith(StyleDefinitions styleDefinitions) {
                return new Note(this.getStartElement(), this.properties, this.storyChildElements, this.getEndElement(), styleDefinitions, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
            }

            static class NoteBuilder
            extends StyledTextReferenceElementBuilder {
                NoteBuilder() {
                }

                @Override
                public StyledTextReferenceElement build() {
                    return new Note(this.startElement, this.properties, this.storyChildElements, this.endElement, this.styleDefinitions, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                }
            }
        }

        static class HyperlinkTextSource
        extends StyledTextReferenceElement {
            HyperlinkTextSource(StartElement startElement, Properties properties, List<StoryChildElement> storyChildElements, EndElement endElement, StyleDefinitions styleDefinitions, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
                super(startElement, properties, storyChildElements, endElement, styleDefinitions, styleRangeEventsGenerator, storyChildElementsWriter);
            }

            @Override
            HyperlinkTextSource copyWith(StyleDefinitions styleDefinitions) {
                return new HyperlinkTextSource(this.getStartElement(), this.properties, this.storyChildElements, this.getEndElement(), styleDefinitions, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
            }

            @Override
            public List<XMLEvent> getEvents() {
                ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
                if (1 == this.storyChildElements.size()) {
                    events.add(this.getStartElement());
                    events.addAll(((StoryChildElement)this.storyChildElements.get(0)).getEvents());
                    events.add(this.getEndElement());
                    return events;
                }
                return super.getEvents();
            }

            static class HyperlinkTextSourceBuilder
            extends StyledTextReferenceElementBuilder {
                HyperlinkTextSourceBuilder() {
                }

                @Override
                public HyperlinkTextSource build() {
                    return new HyperlinkTextSource(this.startElement, this.properties, this.storyChildElements, this.endElement, this.styleDefinitions, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                }
            }
        }

        static class StyledTextReferenceElementBuilder
        extends StyledTextElement.StyledTextElementBuilder {
            protected Properties properties = Properties.getEmptyProperties();
            protected List<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
            protected StyleRangeEventsGenerator styleRangeEventsGenerator;
            protected StoryChildElementsWriter storyChildElementsWriter;

            StyledTextReferenceElementBuilder() {
            }

            StyledTextReferenceElementBuilder setProperties(Properties properties) {
                this.properties = properties;
                return this;
            }

            StyledTextReferenceElementBuilder addStoryChildElements(List<StoryChildElement> storyChildElements) {
                this.storyChildElements.addAll(storyChildElements);
                return this;
            }

            StyledTextReferenceElementBuilder setStyleRangeEventsGenerator(StyleRangeEventsGenerator styleRangeEventsGenerator) {
                this.styleRangeEventsGenerator = styleRangeEventsGenerator;
                return this;
            }

            StyledTextReferenceElementBuilder setStoryChildElementsWriter(StoryChildElementsWriter storyChildElementsWriter) {
                this.storyChildElementsWriter = storyChildElementsWriter;
                return this;
            }

            @Override
            public StyledTextReferenceElement build() {
                return new StyledTextReferenceElement(this.startElement, this.properties, this.storyChildElements, this.endElement, this.styleDefinitions, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
            }
        }
    }

    static class StyledTextElement
    extends StoryChildElement {
        protected final StyleDefinitions styleDefinitions;

        StyledTextElement(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement, StyleDefinitions styleDefinitions) {
            super(startElement, innerEvents, endElement);
            this.styleDefinitions = styleDefinitions;
        }

        StyleDefinitions getStyleDefinitions() {
            return this.styleDefinitions;
        }

        StyledTextElement copyWith(StyleDefinitions styleDefinitions) {
            return new StyledTextElement(this.getStartElement(), this.getInnerEvents(), this.getEndElement(), styleDefinitions);
        }

        static class Break
        extends StyledTextElement {
            Break(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement, StyleDefinitions styleDefinitions) {
                super(startElement, innerEvents, endElement, styleDefinitions);
            }

            @Override
            Break copyWith(StyleDefinitions styleDefinitions) {
                return new Break(this.getStartElement(), this.getInnerEvents(), this.getEndElement(), styleDefinitions);
            }

            static class BreakBuilder
            extends StyledTextElementBuilder {
                BreakBuilder() {
                }

                @Override
                public StoryChildElement build() {
                    return new Break(this.startElement, this.innerEvents, this.endElement, this.styleDefinitions);
                }
            }
        }

        static class Content
        extends StyledTextElement {
            Content(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement, StyleDefinitions styleDefinitions) {
                super(startElement, innerEvents, endElement, styleDefinitions);
            }

            @Override
            Content copyWith(StyleDefinitions styleDefinitions) {
                return new Content(this.getStartElement(), this.getInnerEvents(), this.getEndElement(), styleDefinitions);
            }

            static class ContentBuilder
            extends StyledTextElementBuilder {
                ContentBuilder() {
                }

                @Override
                public StoryChildElement build() {
                    return new Content(this.startElement, this.innerEvents, this.endElement, this.styleDefinitions);
                }
            }
        }

        static class StyledTextElementBuilder
        extends StoryChildElementBuilder {
            protected StyleDefinitions styleDefinitions;

            StyledTextElementBuilder() {
            }

            StyledTextElementBuilder setStyleDefinitions(StyleDefinitions styleDefinitions) {
                this.styleDefinitions = styleDefinitions;
                return this;
            }

            @Override
            public StoryChildElement build() {
                return new StyledTextElement(this.startElement, this.innerEvents, this.endElement, this.styleDefinitions);
            }
        }
    }

    static class StoryChildElementBuilder
    extends MarkupRange.MarkupRangeElement.MarkupRangeElementBuilder {
        StoryChildElementBuilder() {
        }

        @Override
        public StoryChildElement build() {
            return new StoryChildElement(this.startElement, this.innerEvents, this.endElement);
        }
    }
}

