/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CodeTypeBuilder {
    private static final String EMPTY_VALUE = "";
    private boolean addExtendedCodeTypePrefix;
    private Set<String> codeTypes = new LinkedHashSet<String>();
    private Map<String, String> codeTypesAndValues = new LinkedHashMap<String, String>();

    public CodeTypeBuilder(boolean addExtendedCodeTypePrefix) {
        this.addExtendedCodeTypePrefix = addExtendedCodeTypePrefix;
    }

    public void addType(String type) {
        this.codeTypes.add(type);
    }

    public void addType(String type, String value) {
        this.codeTypesAndValues.put(type, value);
    }

    public String build() {
        if (this.codeTypes.isEmpty() && this.codeTypesAndValues.isEmpty()) {
            return EMPTY_VALUE;
        }
        StringBuilder codeTypeBuilder = new StringBuilder(this.addExtendedCodeTypePrefix ? "x-" : EMPTY_VALUE);
        for (String string : this.codeTypes) {
            codeTypeBuilder.append(string).append(";");
        }
        for (Map.Entry entry : this.codeTypesAndValues.entrySet()) {
            codeTypeBuilder.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(";");
        }
        return codeTypeBuilder.toString();
    }
}

