/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.observer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.observer.IObserver;

public class BaseObservable
implements IObservable {
    private final List<IObserver> observers = new CopyOnWriteArrayList<IObserver>();
    private final IObservable observable;

    public BaseObservable(IObservable observable) {
        if (observable == null) {
            throw new NullPointerException("observable is null");
        }
        this.observable = observable;
    }

    @Override
    public void addObserver(IObserver observer) {
        if (observer == null) {
            throw new NullPointerException("observer is null");
        }
        this.observers.add(observer);
    }

    @Override
    public int countObservers() {
        return this.observers.size();
    }

    @Override
    public List<IObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public void deleteObservers() {
        this.observers.clear();
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    @Override
    public void notifyObservers(Object arg) {
        for (IObserver observer : this.observers) {
            this.wrappedNotify(observer, this.observable, arg);
        }
    }

    protected void wrappedNotify(IObserver observer, IObservable observable, Object arg) {
        observer.update(observable, arg);
    }
}

