/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.layerprovider;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.layerprovider.ILayerProvider;

public class LayerProvider
implements ILayerProvider {
    private CharsetEncoder outputEncoder;
    private String lineBreak;
    private String encoding;

    public LayerProvider() {
    }

    public LayerProvider(CharsetEncoder outputEncoder, String lineBreak) {
        this.outputEncoder = outputEncoder;
        this.lineBreak = lineBreak;
    }

    @Override
    public void reset() {
    }

    @Override
    public String endCode() {
        return "}";
    }

    @Override
    public String endInline() {
        return "}";
    }

    @Override
    public String startCode() {
        return "{\\cs5\\f1\\cf15\\lang1024 ";
    }

    @Override
    public String startInline() {
        return "{\\cs6\\f1\\cf6\\lang1024 ";
    }

    @Override
    public String startSegment() {
        return "{\\cs15\\v\\cf12\\sub\\f2 \\{0>}{\\v\\f1 ";
    }

    @Override
    public String endSegment() {
        return "{\\cs15\\v\\cf12\\sub\\f2 <0\\}}";
    }

    @Override
    public String midSegment(int leverage) {
        return String.format("%s%d%s", "}{\\cs15\\v\\cf12\\sub\\f2 <\\}", leverage, "\\{>}");
    }

    @Override
    public String encode(String text, EncoderContext context) {
        return Util.escapeToRTF(text, true, context.ordinal(), this.outputEncoder);
    }

    @Override
    public String encode(char value, EncoderContext context) {
        return Util.escapeToRTF(String.valueOf(value), true, context.ordinal(), this.outputEncoder);
    }

    @Override
    public String encode(int value, EncoderContext context) {
        if (Character.isSupplementaryCodePoint(value)) {
            return Util.escapeToRTF(new String(Character.toChars(value)), true, context.ordinal(), this.outputEncoder);
        }
        return Util.escapeToRTF(String.valueOf((char)value), true, context.ordinal(), this.outputEncoder);
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.outputEncoder = Charset.forName(encoding).newEncoder();
        this.lineBreak = lineBreak;
        this.encoding = encoding;
    }

    @Override
    public String toNative(String propertyName, String value) {
        return value;
    }

    @Override
    public String getLineBreak() {
        return this.lineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        return this.outputEncoder;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }
}

