/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.DeepenSegmentationAnnotaton;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.SimplifierRulesAnnotaton;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Custom;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;
import org.slf4j.Logger;

public class FilterUtil {
    public static final Event createCodeSimplifierEvent(String rules) {
        Custom cr = new Custom();
        SimplifierRulesAnnotaton a = new SimplifierRulesAnnotaton();
        try {
            SimplifierRules.validate(rules);
        }
        catch (ParseException e) {
            throw new OkapiBadFilterInputException("Code simplifier rules are not valid.", e);
        }
        a.setRules(rules);
        cr.setAnnotation(a);
        return new Event(EventType.CUSTOM, cr);
    }

    public static final Event createDeepenSegmentationEvent() {
        Custom cr = new Custom();
        DeepenSegmentationAnnotaton a = new DeepenSegmentationAnnotaton();
        cr.setAnnotation(a);
        return new Event(EventType.CUSTOM, cr);
    }

    public static IFilter createFilter(String configId) {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, true, true);
        return fcMapper.createFilter(configId);
    }

    public static IFilter createFilter(Class<? extends IFilter> filterClass, String configId) {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, true, true);
        fcMapper.addConfigurations(filterClass.getName());
        return fcMapper.createFilter(configId);
    }

    public static IFilter createFilter(String configId, URL ... customConfigs) {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, true, true);
        for (URL customConfig : customConfigs) {
            FilterUtil.addCustomConfig(fcMapper, customConfig);
        }
        IFilter filter = fcMapper.createFilter(configId);
        filter.setFilterConfigurationMapper(fcMapper);
        return filter;
    }

    public static String addCustomConfig(FilterConfigurationMapper fcMapper, URL customConfig) {
        String configId = null;
        try {
            String path = customConfig.toURI().getPath();
            String root = Util.getDirectoryName(path) + File.separator;
            configId = Util.getFilename(path, false);
            fcMapper.setCustomConfigurationsDirectory(root);
            fcMapper.addCustomConfiguration(configId);
            fcMapper.updateCustomConfigurations();
        }
        catch (URISyntaxException e) {
            throw new OkapiIOException(e);
        }
        return configId;
    }

    public static IFilter createFilter(URL customConfig) {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings(fcMapper, true, true);
        return fcMapper.createFilter(FilterUtil.addCustomConfig(fcMapper, customConfig));
    }

    public static void logDebugEvents(Iterable<Event> events, Logger logger) {
        int k = 0;
        for (Event e : events) {
            FilterUtil.logDebugEvent(e, String.format("Event[%d]: ", k), logger);
            ++k;
        }
    }

    public static void logDebugEvent(Event e, String leader, Logger logger) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (leader == null) {
            leader = "";
        }
        StringBuilder sb = new StringBuilder(leader);
        sb.append('\n').append(leader).append(e.getEventType().name());
        if (e.isTextUnit()) {
            ITextUnit tu = e.getTextUnit();
            sb.append(" { id:").append(FilterUtil.nqs(tu.getId())).append(",\n\t");
            FilterUtil.printINameable(sb, "\t", tu);
            sb.append("referent:").append(tu.isReferent()).append(", ");
            sb.append("#refs:").append(tu.getReferenceCount()).append(", ");
            sb.append("\n\ttextParts:[\n");
            for (Segment seg : tu.getSourceSegments()) {
                sb.append("\t\t{seg:\"");
                FilterUtil.appendEscapingNonAscii(sb, TextUnitUtil.toText(seg.text.getCodedText(), seg.text.getCodes()));
                sb.append("\"");
                if (seg.text.getCodes().size() == 0) {
                    sb.append("}");
                    continue;
                }
                sb.append(",\n\t\t codes:{\n");
                sb.append("\t\t\t");
                sb.append(Code.codesToString(seg.text.getCodes()).replaceAll("\u009c", ", ").replace("\u009d", ";\n\t\t\t"));
                sb.append("} }");
            }
            sb.append("\n\t] }");
        } else if (e.isDocumentPart()) {
            DocumentPart dp = e.getDocumentPart();
            sb.append(" { id:").append(FilterUtil.nqs(dp.getId())).append(",\n\t");
            FilterUtil.printINameable(sb, "\t", dp);
            sb.append("referent:").append(dp.isReferent()).append(", ");
            sb.append("#refs:").append(dp.getReferenceCount());
            sb.append("}");
        } else if (e.isStartGroup()) {
            StartGroup sg = e.getStartGroup();
            sb.append(" { id:").append(FilterUtil.nqs(sg.getId())).append(", ");
            FilterUtil.printINameable(sb, "\t", sg);
            sb.append("}");
        } else if (e.isEndGroup()) {
            Ending eg = e.getEndGroup();
            sb.append(" { id:").append(FilterUtil.nqs(eg.getId())).append(",\n\t");
            FilterUtil.printSkeleton(sb, "\t", eg);
            FilterUtil.printAnnotations(sb, "\t", eg);
            sb.append("}");
        } else {
            IResource res = e.getResource();
            sb.append(" { id:").append(FilterUtil.nqs(res.getId())).append(",\n\t");
            FilterUtil.printSkeleton(sb, "\t", res);
            sb.append("}");
        }
        logger.debug(sb.toString());
    }

    private static String nqs(String nullableStr) {
        if (nullableStr == null) {
            return "null";
        }
        return String.format("\"%s\"", nullableStr);
    }

    private static StringBuilder appendEscapingNonAscii(StringBuilder sb, String codedString) {
        for (char c : codedString.toCharArray()) {
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            if (c < ' ' || c >= '\u0100') {
                sb.append(String.format("\\u%04x", c));
                continue;
            }
            sb.append(c);
        }
        return sb;
    }

    private static void printINameable(StringBuilder sb, String ind, INameable res) {
        FilterUtil.printSkeleton(sb, ind, res);
        if (res.getName() != null) {
            sb.append("name:\"").append(res.getName()).append("\", ");
        }
        if (res.getType() != null) {
            sb.append("type:\"").append(res.getType()).append("\", ");
        }
        if (res.getMimeType() != null) {
            sb.append("mimeType:\"").append(res.getMimeType()).append("\", ");
        }
        sb.append("translatable:").append(res.isTranslatable()).append(", ");
        if (res.getPropertyNames() != null && res.getPropertyNames().size() != 0) {
            sb.append(",\n").append(ind).append("properties:{");
            for (String pn : res.getPropertyNames()) {
                sb.append("\"").append(pn).append("\":\"").append(res.getProperty(pn).toString()).append("\", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}, ");
        }
        if (res.getSourcePropertyNames() != null && res.getSourcePropertyNames().size() != 0) {
            sb.append(",\n").append(ind).append("sourceProperties:{");
            for (String pn : res.getSourcePropertyNames()) {
                sb.append("\"").append(pn).append("\":\"").append(res.getSourceProperty(pn).toString()).append("\", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}, ");
        }
        FilterUtil.printAnnotations(sb, ind, res);
    }

    private static void printSkeleton(StringBuilder sb, String ind, IResource res) {
        if (res.getSkeleton() != null) {
            sb.append("skeleton:\"");
            FilterUtil.appendEscapingNonAscii(sb, res.getSkeleton().toString()).append("\",\n").append(ind);
        }
    }

    private static void printAnnotations(StringBuilder sb, String ind, IWithAnnotations res) {
        if (res.getAnnotations() != null && res.getAnnotations().iterator().hasNext()) {
            sb.append("\n").append(ind).append("annotations:[");
            for (IAnnotation ann : res.getAnnotations()) {
                sb.append('\"').append(ann.toString()).append("\", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]");
        }
    }
}

