/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

public enum IssueType {
    MISSING_TARGETTU,
    MISSING_TARGETSEG,
    EXTRA_TARGETSEG,
    EMPTY_TARGETSEG,
    EMPTY_SOURCESEG,
    MISSING_LEADINGWS,
    MISSINGORDIFF_LEADINGWS,
    EXTRA_LEADINGWS,
    EXTRAORDIFF_LEADINGWS,
    MISSING_TRAILINGWS,
    MISSINGORDIFF_TRAILINGWS,
    EXTRA_TRAILINGWS,
    EXTRAORDIFF_TRAILINGWS,
    TARGET_SAME_AS_SOURCE,
    MISSING_CODE,
    EXTRA_CODE,
    SUSPECT_CODE,
    UNEXPECTED_PATTERN,
    SUSPECT_PATTERN,
    SUSPECT_NUMBER,
    SUSPECT_DATE_TIME,
    SOURCE_LENGTH,
    TARGET_LENGTH,
    ALLOWED_CHARACTERS,
    TERMINOLOGY,
    LANGUAGETOOL_ERROR,
    OTHER;


    public static String mapToITS(IssueType issueType) {
        switch (issueType) {
            case MISSING_TARGETTU: 
            case MISSING_TARGETSEG: 
            case EMPTY_TARGETSEG: 
            case EMPTY_SOURCESEG: {
                return "omission";
            }
            case EXTRA_TARGETSEG: {
                return "addition";
            }
            case MISSING_LEADINGWS: 
            case MISSINGORDIFF_LEADINGWS: 
            case EXTRA_LEADINGWS: 
            case EXTRAORDIFF_LEADINGWS: 
            case MISSING_TRAILINGWS: 
            case MISSINGORDIFF_TRAILINGWS: 
            case EXTRA_TRAILINGWS: 
            case EXTRAORDIFF_TRAILINGWS: {
                return "whitespace";
            }
            case TARGET_SAME_AS_SOURCE: {
                return "untranslated";
            }
            case MISSING_CODE: 
            case EXTRA_CODE: 
            case SUSPECT_CODE: {
                return "markup";
            }
            case UNEXPECTED_PATTERN: {
                return "pattern-problem";
            }
            case SUSPECT_PATTERN: 
            case SOURCE_LENGTH: 
            case TARGET_LENGTH: {
                return "length";
            }
            case ALLOWED_CHARACTERS: 
            case TERMINOLOGY: {
                return "terminology";
            }
            case SUSPECT_DATE_TIME: 
            case SUSPECT_NUMBER: {
                return "locale-violation";
            }
            case LANGUAGETOOL_ERROR: {
                return "other";
            }
        }
        return "uncategorized";
    }
}

