/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.time;

import java.util.Objects;
import net.sf.mmm.util.lang.api.attribute.AttributeReadValue;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.validation.NlsBundleUtilValidationRoot;
import net.sf.mmm.util.validation.base.AbstractValueValidator;

public abstract class ValidatorTimeAfter<V>
extends AbstractValueValidator<V> {
    public static final String CODE = "After";
    private final AttributeReadValue<V> boundSource;
    private final V bound;

    public ValidatorTimeAfter(AttributeReadValue<V> valueSource) {
        this.boundSource = valueSource;
        this.bound = null;
    }

    public ValidatorTimeAfter(V value) {
        this.boundSource = null;
        this.bound = value;
    }

    @Override
    public boolean isDynamic() {
        return this.boundSource != null;
    }

    @Override
    protected String getCode() {
        return CODE;
    }

    @Override
    protected NlsMessage validateNotNull(V value) {
        Object limit = this.boundSource == null ? this.bound : this.boundSource.getValue();
        if (this.isAfter(value, limit)) {
            return null;
        }
        return this.createBundle(NlsBundleUtilValidationRoot.class).errorValueNotBefore(value, limit);
    }

    protected abstract boolean isAfter(V var1, V var2);

    @Override
    public int hashCode() {
        if (this.boundSource != null) {
            return ~this.boundSource.hashCode();
        }
        return ~Objects.hashCode(this.bound);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorTimeAfter other = (ValidatorTimeAfter)obj;
        if (!Objects.equals(this.bound, other.bound)) {
            return false;
        }
        return Objects.equals(this.boundSource, other.boundSource);
    }
}

