/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.collection;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sf.mmm.util.validation.api.ValidationFailure;
import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ComposedValueValidator;
import net.sf.mmm.util.validation.base.ValidationFailureComposer;

public class ValidatorMapKeys<K>
extends AbstractValidator<Map<K, ?>>
implements ComposedValueValidator<Map<K, ?>> {
    private final AbstractValidator<? super K>[] validators;

    @SafeVarargs
    public ValidatorMapKeys(AbstractValidator<? super K> ... validators) {
        this.validators = validators;
    }

    public ValidatorMapKeys(List<AbstractValidator<? super K>> validators) {
        this(validators.toArray(new AbstractValidator[validators.size()]));
    }

    @Override
    public AbstractValidator<?> getValidator(int index) {
        return this.validators[index];
    }

    @Override
    public int getValidatorCount() {
        return this.validators.length;
    }

    @Override
    public ValidationFailure validate(Map<K, ?> map, Object valueSource) {
        ValidationFailureComposer composer = new ValidationFailureComposer();
        if (map != null) {
            int i = 0;
            for (K key : map.keySet()) {
                for (AbstractValidator<K> abstractValidator : this.validators) {
                    String source = valueSource == null ? Integer.toString(i) : valueSource.toString() + "." + i;
                    ValidationFailure failure = abstractValidator.validate(key, source);
                    composer.add(failure);
                }
                ++i;
            }
        }
        return composer.get(valueSource);
    }

    @Override
    public int hashCode() {
        return 8642;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorMapKeys other = (ValidatorMapKeys)obj;
        return Objects.equals(this.validators, other.validators);
    }
}

