/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base.collection;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.sf.mmm.util.validation.api.ValidationFailure;
import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ComposedValueValidator;
import net.sf.mmm.util.validation.base.ValidationFailureComposer;

public class ValidatorCollectionElements<E>
extends AbstractValidator<Collection<E>>
implements ComposedValueValidator<Collection<E>> {
    private final AbstractValidator<? super E>[] validators;

    @SafeVarargs
    public ValidatorCollectionElements(AbstractValidator<? super E> ... validators) {
        this.validators = validators;
    }

    public ValidatorCollectionElements(List<AbstractValidator<? super E>> validators) {
        this(validators.toArray(new AbstractValidator[validators.size()]));
    }

    @Override
    public AbstractValidator<?> getValidator(int index) {
        return this.validators[index];
    }

    @Override
    public int getValidatorCount() {
        return this.validators.length;
    }

    @Override
    public ValidationFailure validate(Collection<E> value, Object valueSource) {
        ValidationFailureComposer composer = new ValidationFailureComposer();
        if (value != null) {
            int i = 0;
            for (E element : value) {
                for (AbstractValidator<E> abstractValidator : this.validators) {
                    String source = valueSource == null ? Integer.toString(i) : valueSource.toString() + "." + i;
                    ValidationFailure failure = abstractValidator.validate(element, source);
                    composer.add(failure);
                }
                ++i;
            }
        }
        return composer.get(valueSource);
    }

    @Override
    public int hashCode() {
        return 8420;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorCollectionElements other = (ValidatorCollectionElements)obj;
        return Objects.equals(this.validators, other.validators);
    }
}

