/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import net.sf.mmm.util.exception.api.NlsIllegalArgumentException;
import net.sf.mmm.util.exception.api.NlsNullPointerException;
import net.sf.mmm.util.pojo.api.TypedProperty;
import net.sf.mmm.util.validation.NlsBundleUtilValidationRoot;
import net.sf.mmm.util.validation.api.ValidationFailure;
import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ComposedValidationFailure;
import net.sf.mmm.util.validation.base.Mandatory;
import net.sf.mmm.util.validation.base.ValidationFailureImpl;

public class ValidatorJsr303<V>
extends AbstractValidator<V> {
    private final Validator validator;
    private final Class<?> pojoType;
    private final String property;
    private final Class<?> propertyType;
    private final Class<?>[] groups;
    private final boolean mandatory;

    public ValidatorJsr303(Validator validator, Class<V> pojoType) {
        this(validator, pojoType, (String)null);
    }

    public ValidatorJsr303(Validator validator, Class<V> pojoType, Class<?> ... groups) {
        this(validator, (Class<?>)pojoType, (String)null, (Class<?>)null, groups);
    }

    public ValidatorJsr303(Validator validator, Class<?> pojoType, String property) {
        this(validator, pojoType, property, null);
    }

    public ValidatorJsr303(Validator validator, Class<?> pojoType, String property, Class<?> propertyType) {
        this(validator, pojoType, property, propertyType, Default.class);
    }

    public ValidatorJsr303(Validator validator, Class<?> pojoType, String property, Class<?> propertyType, Class<?> ... groups) {
        NlsNullPointerException.checkNotNull(Validator.class, (Object)validator);
        NlsNullPointerException.checkNotNull((String)"pojoType", pojoType);
        NlsNullPointerException.checkNotNull((String)"groups", groups);
        if (property == null && propertyType != null) {
            throw new NlsIllegalArgumentException(propertyType, "propertyType (property=null)");
        }
        this.validator = validator;
        this.pojoType = pojoType;
        this.property = property;
        this.propertyType = propertyType;
        this.groups = groups;
        this.mandatory = this.calculateMandatoryFlag();
    }

    @Override
    public <P> P getProperty(TypedProperty<P> typedProperty) {
        if (typedProperty == PROPERTY_MANDATORY) {
            if (this.mandatory) {
                return (P)Boolean.TRUE;
            }
            return null;
        }
        return super.getProperty(typedProperty);
    }

    private boolean calculateMandatoryFlag() {
        if (this.property != null) {
            if (this.propertyType != null && this.propertyType.isPrimitive()) {
                return true;
            }
            BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(this.pojoType);
            PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(this.property);
            if (propertyDescriptor == null) {
                return false;
            }
            Set constraintDescriptors = propertyDescriptor.getConstraintDescriptors();
            for (ConstraintDescriptor descriptor : constraintDescriptors) {
                Class<? extends Annotation> annotationType = descriptor.getAnnotation().annotationType();
                if (Mandatory.class == annotationType) {
                    return true;
                }
                if (NotNull.class != annotationType) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ValidationFailure validate(V value, Object valueSource) {
        if (value == null && this.propertyType != null && this.propertyType.isPrimitive()) {
            return new ValidationFailureImpl(Mandatory.class.getSimpleName(), valueSource, this.createBundle(NlsBundleUtilValidationRoot.class).errorMandatory());
        }
        Set<ConstraintViolation<?>> violationSet = this.validateJsr303(value);
        int size = violationSet.size();
        if (size == 1) {
            ConstraintViolation<?> violation = violationSet.iterator().next();
            return this.createValidationFailure(violation, valueSource);
        }
        if (size > 1) {
            ValidationFailure[] failures = new ValidationFailure[size];
            int i = 0;
            for (ConstraintViolation<?> violation : violationSet) {
                failures[i++] = this.createValidationFailure(violation, valueSource);
            }
            return new ComposedValidationFailure(this.getCode(), valueSource, failures);
        }
        return null;
    }

    private Set<ConstraintViolation<?>> validateJsr303(V value) {
        Set set;
        if (this.property == null) {
            if (value == null) {
                return null;
            }
            set = this.validator.validate(value, (Class[])this.groups);
        } else {
            set = this.validator.validateValue(this.pojoType, this.property, value, (Class[])this.groups);
        }
        Set violationSet = set;
        return violationSet;
    }

    protected ValidationFailure createValidationFailure(ConstraintViolation<?> violation, Object valueSource) {
        String code = violation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName();
        return new ValidationFailureImpl(code, valueSource, violation.getMessage());
    }

    @Override
    protected String getCode() {
        StringBuilder buffer = new StringBuilder("JSR303@");
        buffer.append(this.pojoType.getSimpleName());
        if (this.property != null) {
            buffer.append('.');
            buffer.append(this.property);
        }
        return buffer.toString();
    }

    public Class<?> getPojoType() {
        return this.pojoType;
    }

    public String getProperty() {
        return this.property;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pojoType, this.property);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorJsr303 other = (ValidatorJsr303)obj;
        if (!Objects.equals(this.pojoType, other.pojoType)) {
            return false;
        }
        if (!Objects.equals(this.property, other.property)) {
            return false;
        }
        return Arrays.equals(this.groups, other.groups);
    }
}

