/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.mmm.util.lang.api.Builder;
import net.sf.mmm.util.validation.base.AbstractValidator;
import net.sf.mmm.util.validation.base.ComposedValidator;
import net.sf.mmm.util.validation.base.ValidatorMandatory;
import net.sf.mmm.util.validation.base.ValidatorNone;
import net.sf.mmm.util.validation.base.ValidatorRegistry;

public abstract class ObjectValidatorBuilder<V, PARENT, SELF extends ObjectValidatorBuilder<V, PARENT, SELF>>
implements Builder<AbstractValidator<? super V>>,
ValidatorRegistry<V, SELF> {
    private final PARENT parent;
    private final List<AbstractValidator<? super V>> validators = new ArrayList<AbstractValidator<? super V>>();

    public ObjectValidatorBuilder(PARENT parent) {
        this.parent = parent;
    }

    protected <T> List<AbstractValidator<? super T>> getValidators(ObjectValidatorBuilder<T, ?, ?> builder) {
        return builder.validators;
    }

    public PARENT and() {
        return this.parent;
    }

    protected SELF self() {
        return (SELF)this;
    }

    @Override
    public SELF add(AbstractValidator<? super V> validator) {
        this.validators.add(validator);
        return this.self();
    }

    public SELF mandatory() {
        return (SELF)this.add((AbstractValidator)ValidatorMandatory.getInstance());
    }

    public abstract SELF range(String var1, String var2);

    public AbstractValidator<? super V> build() {
        int size = this.validators.size();
        if (size == 0) {
            return ValidatorNone.getInstance();
        }
        if (size == 1) {
            return this.validators.get(0);
        }
        AbstractValidator[] array = this.validators.toArray(new AbstractValidator[size]);
        return new ComposedValidator(array);
    }
}

