/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base;

import java.util.Iterator;
import java.util.Locale;
import net.sf.mmm.util.collection.base.ArrayIterator;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.validation.api.ValidationFailure;
import net.sf.mmm.util.validation.base.AbstractValidationFailure;

public class ComposedValidationFailure
extends AbstractValidationFailure
implements Iterable<ValidationFailure> {
    public static final String CODE = "ComposedValidator";
    private static final long serialVersionUID = -5191509274230075436L;
    private ValidationFailure[] failures;

    protected ComposedValidationFailure() {
    }

    public ComposedValidationFailure(Object source, ValidationFailure[] failures) {
        this(CODE, source, failures);
    }

    public ComposedValidationFailure(String code, Object source, ValidationFailure[] failures) {
        super(code, source, (NlsMessage)null, null, null);
        this.failures = failures;
    }

    protected String getSeparator() {
        return "\n";
    }

    @Override
    public Iterator<ValidationFailure> iterator() {
        return new ArrayIterator((Object[])this.failures);
    }

    public int getFailureCount() {
        return this.failures.length;
    }

    public ValidationFailure getFailure(int index) {
        return this.failures[index];
    }

    public String getDetails() {
        StringBuilder buffer = new StringBuilder();
        for (ValidationFailure failure : this.failures) {
            String details = failure.getDetails();
            if (details == null) continue;
            if (buffer.length() > 0) {
                buffer.append(this.getSeparator());
            }
            buffer.append(details);
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    public String getMessage(Locale locale) {
        StringBuilder buffer = new StringBuilder();
        for (ValidationFailure failure : this.failures) {
            if (buffer.length() > 0) {
                buffer.append(this.getSeparator());
            }
            String message = locale == null ? failure.getMessage() : failure.getMessage(locale);
            buffer.append(message);
        }
        return buffer.toString();
    }
}

