/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.validation.base;

import java.util.Objects;
import net.sf.mmm.util.exception.NlsBundleUtilExceptionRoot;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.pojo.api.TypedProperty;
import net.sf.mmm.util.validation.base.AbstractValueValidator;
import net.sf.mmm.util.value.api.Range;

public class AbstractValidatorRange<V, R>
extends AbstractValueValidator<V> {
    public static final String CODE = "Range";
    private final Range<R> range;

    public AbstractValidatorRange(Range<R> range) {
        this.range = range;
    }

    @Override
    protected String getCode() {
        return CODE;
    }

    public Range<R> getRange() {
        return this.range;
    }

    protected R convertValue(V value) {
        return (R)value;
    }

    @Override
    protected NlsMessage validateNotNull(V value) {
        R convertedValue = this.convertValue(value);
        if (this.range.isContained(convertedValue)) {
            return null;
        }
        return this.createBundle(NlsBundleUtilExceptionRoot.class).errorValueOutOfRange(convertedValue, this.range.getMin(), this.range.getMax(), null);
    }

    @Override
    public <P> P getProperty(TypedProperty<P> property) {
        if (property == PROPERTY_MINIMUM) {
            return (P)this.range.getMin();
        }
        if (property == PROPERTY_MAXIMUM) {
            return (P)this.range.getMax();
        }
        return super.getProperty(property);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.range);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractValidatorRange other = (AbstractValidatorRange)obj;
        return Objects.equals(this.range, other.range);
    }
}

