/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.sf.mmm.util.reflect.api.ReflectionUtil;

public class TypeVariableImpl<DECLARATION extends GenericDeclaration>
implements TypeVariable<DECLARATION> {
    private final String name;
    private final Type[] bounds;
    private final DECLARATION genericDeclaration;

    public TypeVariableImpl(String name, DECLARATION declaration, Type[] bounds) {
        this.name = name;
        this.genericDeclaration = declaration;
        this.bounds = bounds;
    }

    @Override
    public Type[] getBounds() {
        return this.bounds;
    }

    @Override
    public DECLARATION getGenericDeclaration() {
        return this.genericDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    @Override
    public Annotation[] getAnnotations() {
        return ReflectionUtil.NO_ANNOTATIONS;
    }

    @Override
    public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    @Override
    public AnnotatedType[] getAnnotatedBounds() {
        return new AnnotatedType[0];
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TypeVariable) {
            TypeVariable otherVariable = (TypeVariable)other;
            return this.name.equals(otherVariable.getName()) && this.genericDeclaration.equals(otherVariable.getGenericDeclaration());
        }
        return false;
    }

    public int hashCode() {
        return this.genericDeclaration.hashCode() ^ this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

