/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.mmm.util.reflect.api.GenericType;

public class SimpleGenericTypeLimited<T>
implements GenericType<T> {
    public static final GenericType<Object> TYPE_OBJECT = new SimpleGenericTypeLimited<Object>(Object.class);
    public static final GenericType<Void> TYPE_VOID = new SimpleGenericTypeLimited<Void>(Void.class);
    private final Class<T> type;
    private GenericType<?> componentType;
    private GenericType<?> keyType;

    public SimpleGenericTypeLimited(Class<T> type) {
        Objects.requireNonNull(type, "type");
        this.type = type;
        if (type.isArray()) {
            this.componentType = new SimpleGenericTypeLimited(type.getComponentType());
            this.keyType = null;
        } else if (this.isCollection(type)) {
            this.componentType = TYPE_OBJECT;
            this.keyType = null;
        } else if (this.isMap(type)) {
            this.componentType = TYPE_OBJECT;
            this.keyType = TYPE_OBJECT;
        } else {
            this.componentType = null;
            this.keyType = null;
        }
    }

    private boolean isCollection(Class<?> rawType) {
        if (rawType == Collection.class) {
            return true;
        }
        if (rawType == List.class) {
            return true;
        }
        if (rawType == Set.class) {
            return true;
        }
        for (Class<?> superType = rawType; superType != null; superType = superType.getSuperclass()) {
            if (superType != AbstractCollection.class) continue;
            return true;
        }
        return false;
    }

    private boolean isMap(Class<?> rawType) {
        if (rawType == Map.class) {
            return true;
        }
        for (Class<?> superType = rawType; superType != null; superType = superType.getSuperclass()) {
            if (superType != AbstractMap.class) continue;
            return true;
        }
        return false;
    }

    @Override
    public GenericType<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public GenericType<?> getKeyType() {
        return this.keyType;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Class<T> getAssignmentClass() {
        return this.type;
    }

    @Override
    public Class<T> getRetrievalClass() {
        return this.type;
    }

    @Override
    public GenericType<?> getTypeArgument(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public int getTypeArgumentCount() {
        return 0;
    }

    @Override
    public boolean isAssignableFrom(GenericType<?> subType) {
        throw new UnsupportedOperationException("GWT:isAssignableFrom");
    }

    @Override
    public boolean isMap() {
        return this.keyType != null;
    }

    @Override
    public boolean isCollection() {
        return this.componentType != null && !this.type.isArray();
    }

    public int hashCode() {
        return ~this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleGenericTypeLimited other = (SimpleGenericTypeLimited)obj;
        return this.type.equals(other.type);
    }

    @Override
    public String toString() {
        return this.type.getName();
    }

    @Override
    public String toStringSimple() {
        return this.type.getSimpleName();
    }
}

