/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ManifestLoader {
    public static final Attributes.Name MANIFEST_SOURCE = new Attributes.Name("Manifest-Source");
    private static final String JAR_SUFFIX = ".jar!/META-INF/MANIFEST.MF";
    private final List<Manifest> manifests;

    public ManifestLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestLoader(ClassLoader classloader) {
        try {
            ArrayList<Manifest> mutableList = new ArrayList<Manifest>();
            Enumeration<URL> urls = classloader.getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (InputStream inputStream = url.openStream();){
                    Manifest manifest = new Manifest();
                    manifest.read(inputStream);
                    ManifestLoader.completeManifest(manifest, url);
                    mutableList.add(manifest);
                }
            }
            this.manifests = Collections.unmodifiableList(mutableList);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read manifest.", e);
        }
    }

    private static void completeManifest(Manifest manifest, URL url) {
        String path = url.getPath();
        int start = 0;
        int end = path.length();
        if (path.endsWith(JAR_SUFFIX)) {
            end = end - JAR_SUFFIX.length() + 4;
            start = path.lastIndexOf(47, end) + 1;
        }
        String source = path.substring(start, end);
        manifest.getMainAttributes().put(MANIFEST_SOURCE, source);
    }

    public List<Manifest> getManifests() {
        return this.manifests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest loadManifest(Class<?> type) {
        try {
            Manifest manifest = null;
            String classpath = type.getName().replace('.', '/') + ".class";
            URL classUrl = type.getClassLoader().getResource(classpath);
            if (classUrl != null) {
                String rootpath;
                File manifestFile;
                String urlString;
                String protocol = classUrl.getProtocol().toLowerCase(Locale.US);
                if ("jar".equals(protocol)) {
                    JarURLConnection connection = (JarURLConnection)classUrl.openConnection();
                    JarFile jarFile = connection.getJarFile();
                    manifest = new Manifest(jarFile.getManifest());
                } else if ("file".equals(protocol) && (urlString = URLDecoder.decode(classUrl.getFile(), "UTF-8")).endsWith(classpath) && (manifestFile = new File(rootpath = urlString.substring(0, urlString.length() - classpath.length()), "META-INF/MANIFEST.MF")).exists()) {
                    try (FileInputStream inputStream = new FileInputStream(manifestFile);){
                        manifest = new Manifest(inputStream);
                    }
                }
            }
            return manifest;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read manifest.", e);
        }
    }

    public static String getValue(Manifest manifest, Attributes.Name name) {
        String value = manifest.getMainAttributes().getValue(name);
        if (value == null) {
            for (Attributes attributes : manifest.getEntries().values()) {
                value = attributes.getValue(name);
            }
        }
        return value;
    }
}

