/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import net.sf.mmm.util.lang.api.CaseSyntax;
import net.sf.mmm.util.lang.api.attribute.AttributeReadValue;

public class EnumHelper {
    public static <E extends Enum<E>> E fromString(String value, Class<E> enumType) {
        Enum[] constants;
        if (value == null) {
            return null;
        }
        for (Enum e : constants = (Enum[])enumType.getEnumConstants()) {
            if (!e.name().equals(value)) continue;
            return (E)e;
        }
        if (AttributeReadValue.class.isAssignableFrom(enumType)) {
            for (Enum e : constants) {
                Object v = ((AttributeReadValue)e).getValue();
                if (v == null || !value.equalsIgnoreCase(v.toString())) continue;
                return (E)e;
            }
        }
        for (Enum e : constants) {
            String name = e.name();
            if (value.equalsIgnoreCase(name)) {
                return (E)e;
            }
            if (value.equalsIgnoreCase(name = name.replace("_", "-"))) {
                return (E)e;
            }
            if (!value.equalsIgnoreCase(name = name.replace("-", ""))) continue;
            return (E)e;
        }
        throw new IllegalStateException(value + "@" + enumType.getName());
    }

    public static String toString(Enum<?> value, boolean camlCase, boolean deCapitalze) {
        char c;
        char low;
        if (value == null) {
            return null;
        }
        String string = value.toString();
        if (camlCase) {
            string = deCapitalze ? CaseSyntax.CAML_CASE.convert(string) : CaseSyntax.PASCAL_CASE.convert(string);
        } else if (deCapitalze && !string.isEmpty() && (low = Character.toLowerCase(c = string.charAt(0))) != c) {
            string = low + string.substring(1);
        }
        return string;
    }
}

