/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.base;

import java.lang.annotation.Annotation;
import net.sf.mmm.util.filter.api.Filter;
import net.sf.mmm.util.reflect.base.AnnotationUtilImpl;

public class AnnotationFilter
implements Filter<Class<?>> {
    private AnnotationUtilImpl annotationUtil;
    private final Class<? extends Annotation> annotationType;
    private final boolean forceInheritence;

    public AnnotationFilter(Class<? extends Annotation> annotationType) throws IllegalArgumentException {
        this(annotationType, false);
    }

    public AnnotationFilter(Class<? extends Annotation> annotationType, boolean forceInheritence) throws IllegalArgumentException {
        this(annotationType, forceInheritence, AnnotationUtilImpl.getInstance());
    }

    public AnnotationFilter(Class<? extends Annotation> annotationType, boolean forceInheritence, AnnotationUtilImpl annotationUtil) throws IllegalArgumentException {
        if (!annotationUtil.isRuntimeAnnotation(annotationType)) {
            throw new IllegalArgumentException("Given annotation (" + annotationType + ") can NOT be resolved at runtime!");
        }
        this.annotationUtil = annotationUtil;
        this.annotationType = annotationType;
        this.forceInheritence = forceInheritence;
    }

    public boolean accept(Class<?> type) {
        if (type != null) {
            if (this.forceInheritence) {
                Annotation annotation = this.annotationUtil.getTypeAnnotation(type, this.annotationType);
                return annotation != null;
            }
            return type.isAnnotationPresent(this.annotationType);
        }
        return false;
    }
}

