/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.reflect.api;

import java.lang.reflect.Method;
import java.util.Objects;
import net.sf.mmm.util.reflect.api.Signature;
import net.sf.mmm.util.reflect.base.ReflectionUtilImpl;

public class NamedSignature
extends Signature {
    private String name;

    public NamedSignature(String name, Class<?> ... theSignature) {
        super(name.hashCode(), theSignature);
        this.name = name;
    }

    public NamedSignature(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public NamedSignature(String name, Object ... arguments) {
        this(name, ReflectionUtilImpl.getInstance().getClasses(arguments));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        NamedSignature otherSignature = (NamedSignature)other;
        return Objects.equals(this.name, otherSignature.name);
    }

    @Override
    protected void toString(StringBuilder buffer) {
        buffer.append(this.name);
        super.toString(buffer);
    }
}

