/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.impl.formatter;

import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Locale;
import java.util.Map;
import net.sf.mmm.util.nls.api.NlsTemplateResolver;
import net.sf.mmm.util.nls.base.AbstractNlsFormatterPlugin;

public class NlsFormatterType
extends AbstractNlsFormatterPlugin<Object> {
    private static final Package PACKAGE_JAVA_LANG = Package.class.getPackage();
    private final String style;

    public NlsFormatterType(String style) {
        this.style = style;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public String getType() {
        return "type";
    }

    @Override
    public void format(Object object, Locale locale, Map<String, Object> arguments, NlsTemplateResolver resolver, Appendable buffer) throws IOException {
        if (object == null) {
            buffer.append("null");
        } else if (object instanceof Type) {
            this.toString((Type)object, buffer);
        } else {
            buffer.append(object.toString());
        }
    }

    private void toString(Type type, Appendable appendable) {
        try {
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (this.style.equals("short")) {
                    appendable.append(clazz.getSimpleName());
                } else if (this.style.equals("long") || this.style.equals("medium")) {
                    if (PACKAGE_JAVA_LANG.equals(clazz.getPackage())) {
                        appendable.append(clazz.getSimpleName());
                    } else {
                        appendable.append(clazz.getCanonicalName());
                    }
                } else {
                    appendable.append(clazz.getCanonicalName());
                }
            } else if (type instanceof ParameterizedType) {
                Type ownerType;
                boolean longOrFullStyle;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                boolean bl = longOrFullStyle = this.style.equals("long") || this.style.equals("full");
                if (longOrFullStyle && (ownerType = parameterizedType.getOwnerType()) != null) {
                    this.toString(ownerType, appendable);
                    appendable.append('.');
                }
                this.toString(parameterizedType.getRawType(), appendable);
                if (longOrFullStyle) {
                    appendable.append('<');
                    boolean separator = false;
                    for (Type arg : parameterizedType.getActualTypeArguments()) {
                        if (separator) {
                            appendable.append(", ");
                        }
                        this.toString(arg, appendable);
                        separator = true;
                    }
                    appendable.append('>');
                }
            } else if (type instanceof TypeVariable) {
                Type firstBound;
                TypeVariable typeVariable = (TypeVariable)type;
                appendable.append(typeVariable.getName());
                Type[] bounds = typeVariable.getBounds();
                if (bounds.length > 0 && !Object.class.equals((Object)(firstBound = bounds[0]))) {
                    appendable.append(" extends ");
                    this.toString(firstBound, appendable);
                }
            } else if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] lowerBounds = wildcardType.getLowerBounds();
                if (lowerBounds.length > 0) {
                    appendable.append("? super ");
                    this.toString(lowerBounds[0], appendable);
                } else {
                    Type[] upperBounds = wildcardType.getUpperBounds();
                    if (upperBounds.length > 0) {
                        appendable.append("? extends ");
                        this.toString(upperBounds[0], appendable);
                    } else {
                        appendable.append("?");
                    }
                }
            } else if (type instanceof GenericArrayType) {
                this.toString(((GenericArrayType)type).getGenericComponentType(), appendable);
                appendable.append("[]");
            } else {
                appendable.append(type.toString());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error writing type to Appendable.", e);
        }
    }
}

