/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import java.util.Map;
import net.sf.mmm.util.nls.api.NlsAccess;
import net.sf.mmm.util.nls.api.NlsBundleWithLookup;
import net.sf.mmm.util.nls.api.NlsMessage;
import net.sf.mmm.util.nls.api.NlsMessageLookup;

public class NlsMessageLookupProxy
implements NlsMessageLookup {
    private final NlsMessageLookup[] delegates;

    public NlsMessageLookupProxy(NlsMessageLookup ... delegates) {
        this.delegates = delegates;
    }

    @SafeVarargs
    public NlsMessageLookupProxy(Class<? extends NlsBundleWithLookup> ... bundles) {
        this.delegates = new NlsBundleWithLookup[bundles.length];
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i] = NlsAccess.getBundleFactory().createBundle(bundles[i]);
        }
    }

    @Override
    public NlsMessage getMessage(String key, Map<String, Object> nlsArguments) {
        for (NlsMessageLookup lookup : this.delegates) {
            NlsMessage message = lookup.getMessage(key, nlsArguments);
            if (message == null) continue;
            return message;
        }
        return null;
    }
}

