/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.nls.base;

import javax.inject.Inject;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.filter.api.CharFilter;
import net.sf.mmm.util.filter.base.ListCharFilter;
import net.sf.mmm.util.nls.api.NlsArgument;
import net.sf.mmm.util.nls.api.NlsArgumentParser;
import net.sf.mmm.util.nls.api.NlsFormatterManager;
import net.sf.mmm.util.nls.api.NlsFormatterPlugin;
import net.sf.mmm.util.nls.impl.formatter.NlsFormatterManagerImpl;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;
import net.sf.mmm.util.text.api.Justification;
import net.sf.mmm.util.text.api.JustificationBuilder;
import net.sf.mmm.util.text.base.JustificationBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNlsFormatterManager
extends AbstractComponent
implements NlsFormatterManager,
NlsArgumentParser {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNlsFormatterManager.class);
    protected static final CharFilter NO_COMMA_OR_END_EXPRESSION = new ListCharFilter(false, new char[]{',', '}'});
    protected static final CharFilter NO_EXPRESSION = new ListCharFilter(false, new char[]{'{', '}'});
    private static AbstractNlsFormatterManager instance;
    private JustificationBuilder justificationBuilder;

    public static AbstractNlsFormatterManager getInstance() {
        if (instance == null) {
            new NlsFormatterManagerImpl().initialize();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialized() {
        super.doInitialized();
        Class<AbstractNlsFormatterManager> clazz = AbstractNlsFormatterManager.class;
        synchronized (AbstractNlsFormatterManager.class) {
            if (instance == null) {
                instance = this;
            } else if (instance != this) {
                LOG.warn("Duplicate instances {} and {} (getInstance() vs. IoC)", (Object)instance, (Object)this);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public NlsArgument parse(CharSequenceScanner scanner) {
        String key = scanner.readWhile(CharFilter.IDENTIFIER_FILTER);
        char c = scanner.next();
        int index = scanner.getCurrentIndex();
        String formatType = null;
        NlsFormatterPlugin<?> formatter = null;
        if (c == ',') {
            formatType = scanner.readWhile(NO_COMMA_OR_END_EXPRESSION);
            index = scanner.getCurrentIndex();
            c = scanner.forceNext();
            if (c == ',') {
                index = scanner.getCurrentIndex();
                try {
                    formatter = this.getSubFormatter(formatType, scanner);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to parse '" + scanner.substring(index, scanner.getCurrentIndex()) + "' as NlsFormatter.", e);
                }
                c = scanner.forceNext();
            } else {
                formatter = this.getFormatter(formatType);
            }
        }
        Justification justification = null;
        if (c == '{') {
            String formatJustification = scanner.readUntil('}', false);
            justification = this.getJustificationBuilder().build(formatJustification);
            c = scanner.forceNext();
        }
        if (c != '}') {
            throw new IllegalArgumentException(scanner.substring(index, scanner.getCurrentIndex()));
        }
        if (formatter == null) {
            formatter = this.getFormatter();
        }
        return new NlsArgument(key, formatter, justification);
    }

    protected NlsFormatterPlugin<?> getSubFormatter(String formatType, CharSequenceScanner scanner) {
        String formatStyle = scanner.readWhile(NO_EXPRESSION);
        return this.getFormatter(formatType, formatStyle);
    }

    protected void doInitialize() {
        super.doInitialize();
        if (this.justificationBuilder == null) {
            this.justificationBuilder = JustificationBuilderImpl.getInstance();
        }
    }

    protected JustificationBuilder getJustificationBuilder() {
        return this.justificationBuilder;
    }

    @Inject
    public void setJustificationBuilder(JustificationBuilder justificationBuilder) {
        this.getInitializationState().requireNotInitilized();
        this.justificationBuilder = justificationBuilder;
    }

    public NlsFormatterPlugin<Object> getFormatter() {
        return this.getFormatter(null);
    }

    public NlsFormatterPlugin<?> getFormatter(String formatType) {
        return this.getFormatter(formatType, null);
    }
}

