/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.math.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.mmm.util.component.base.AbstractComponent;
import net.sf.mmm.util.math.api.MathUtilLimited;
import net.sf.mmm.util.math.api.NumberType;
import net.sf.mmm.util.math.base.NumberTypeImpl;

public class MathUtilLimitedImpl
extends AbstractComponent
implements MathUtilLimited {
    @Override
    public NumberType<? extends Number> getNumberType(Class<?> numericType) {
        if (numericType == Integer.TYPE || numericType == Integer.class) {
            return NumberTypeImpl.INTEGER;
        }
        if (numericType == Long.TYPE || numericType == Long.class) {
            return NumberTypeImpl.LONG;
        }
        if (numericType == Double.TYPE || numericType == Double.class) {
            return NumberTypeImpl.DOUBLE;
        }
        if (numericType == Float.TYPE || numericType == Float.class) {
            return NumberTypeImpl.FLOAT;
        }
        if (numericType == Short.TYPE || numericType == Short.class) {
            return NumberTypeImpl.SHORT;
        }
        if (numericType == Byte.TYPE || numericType == Byte.class) {
            return NumberTypeImpl.BYTE;
        }
        if (BigInteger.class.equals(numericType)) {
            return NumberTypeImpl.BIG_INTEGER;
        }
        if (BigDecimal.class.equals(numericType)) {
            return NumberTypeImpl.BIG_DECIMAL;
        }
        return null;
    }

    @Override
    public <NUMBER extends Number> NumberType<NUMBER> getNumberTypeGeneric(Class<NUMBER> numericType) {
        return this.getNumberType(numericType);
    }

    @Override
    public Number toSimplestNumber(Number value) {
        double d = value.doubleValue();
        long l = value.longValue();
        if ((double)l == d) {
            if ((double)value.byteValue() == d) {
                return value.byteValue();
            }
            if ((double)value.shortValue() == d) {
                return value.shortValue();
            }
            if ((double)value.intValue() == d) {
                return value.intValue();
            }
            return l;
        }
        if ((double)value.floatValue() == d) {
            return Float.valueOf(value.floatValue());
        }
        return value;
    }
}

