/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.math.base;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.mmm.util.math.api.MathUtil;
import net.sf.mmm.util.math.api.NumberType;
import net.sf.mmm.util.math.base.MathUtilLimitedImpl;
import net.sf.mmm.util.math.base.NumberTypeImpl;

public class MathUtilImpl
extends MathUtilLimitedImpl
implements MathUtil {
    public static final NumberTypeImpl<AtomicLong> ATOMIC_LONG = new NumberTypeImpl<AtomicLong>(4, null, null){

        @Override
        public Class<AtomicLong> getNumberClass() {
            return AtomicLong.class;
        }

        @Override
        public boolean isDecimal() {
            return false;
        }

        @Override
        protected AtomicLong convert(Number number) {
            return new AtomicLong(number.longValue());
        }

        @Override
        protected AtomicLong parse(String number) throws NumberFormatException {
            return new AtomicLong(Long.parseLong(number));
        }

        @Override
        public AtomicLong getMinimumValue() {
            return new AtomicLong(Long.MIN_VALUE);
        }

        @Override
        public AtomicLong getMaximumValue() {
            return new AtomicLong(Long.MAX_VALUE);
        }
    };
    public static final NumberTypeImpl<AtomicInteger> ATOMIC_INTEGER = new NumberTypeImpl<AtomicInteger>(3, null, null){

        @Override
        public Class<AtomicInteger> getNumberClass() {
            return AtomicInteger.class;
        }

        @Override
        public boolean isDecimal() {
            return false;
        }

        @Override
        protected AtomicInteger convert(Number number) {
            return new AtomicInteger(number.intValue());
        }

        @Override
        protected AtomicInteger parse(String number) throws NumberFormatException {
            return new AtomicInteger(Integer.parseInt(number));
        }

        @Override
        public AtomicInteger getMinimumValue() {
            return new AtomicInteger(Integer.MIN_VALUE);
        }

        @Override
        public AtomicInteger getMaximumValue() {
            return new AtomicInteger(Integer.MAX_VALUE);
        }
    };
    private static MathUtil instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MathUtil getInstance() {
        if (instance != null) return instance;
        Class<MathUtilImpl> clazz = MathUtilImpl.class;
        synchronized (MathUtilImpl.class) {
            if (instance != null) return instance;
            MathUtilImpl impl = new MathUtilImpl();
            impl.initialize();
            instance = impl;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public NumberType<? extends Number> getNumberType(Class<?> numericType) {
        if (AtomicInteger.class.isAssignableFrom(numericType)) {
            return ATOMIC_INTEGER;
        }
        if (AtomicLong.class.isAssignableFrom(numericType)) {
            return ATOMIC_LONG;
        }
        return super.getNumberType(numericType);
    }
}

