/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import net.sf.mmm.util.lang.api.Alignment;
import net.sf.mmm.util.lang.api.attribute.AttributeReadValue;

public enum HorizontalAlignment implements AttributeReadValue<String>
{
    LEFT("-", "left"),
    RIGHT("+", "right"),
    CENTER("~", "center");

    private final String value;
    private final String title;

    private HorizontalAlignment(String value, String title) {
        this.value = value;
        this.title = title;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Alignment getAlignment() {
        switch (this) {
            case LEFT: {
                return Alignment.LEFT;
            }
            case CENTER: {
                return Alignment.CENTER;
            }
            case RIGHT: {
                return Alignment.RIGHT;
            }
        }
        throw new IllegalStateException(this.name());
    }

    public String toString() {
        return this.title;
    }

    public static HorizontalAlignment fromValue(String value) {
        for (HorizontalAlignment alignment : HorizontalAlignment.values()) {
            if (!alignment.value.equals(value)) continue;
            return alignment;
        }
        return null;
    }
}

