/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import net.sf.mmm.util.lang.api.attribute.AttributeReadValue;

public enum Direction implements AttributeReadValue<String>
{
    SOUTH("S", "south"),
    EAST("E", "east"),
    WEST("W", "west"),
    NORTH("N", "north"),
    SOUTH_EAST("SE", "south-east"),
    SOUTH_WEST("SW", "south-west"),
    NORTH_EAST("NE", "north-east"),
    NORTH_WEST("NW", "north-west");

    private final String value;
    private final String title;

    private Direction(String value, String title) {
        this.value = value;
        this.title = title;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.title;
    }

    public boolean isToEast() {
        return this == EAST || this == SOUTH_EAST || this == NORTH_EAST;
    }

    public boolean isToWest() {
        return this == WEST || this == SOUTH_WEST || this == NORTH_WEST;
    }

    public boolean isToSouth() {
        return this == SOUTH || this == SOUTH_EAST || this == SOUTH_WEST;
    }

    public boolean isToNorth() {
        return this == NORTH || this == NORTH_EAST || this == NORTH_WEST;
    }
}

