/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

public class CharEscapeHelper {
    private static final Character CHAR_TAB = Character.valueOf('\t');
    private static final Character CHAR_BACKSLASH = Character.valueOf('\\');
    private static final Character CHAR_CR = Character.valueOf('\r');
    private static final Character CHAR_LF = Character.valueOf('\n');
    private static final Character CHAR_SINGLE_QUOTE = Character.valueOf('\'');
    private static final Character CHAR_DOUBLE_QUOTE = Character.valueOf('\"');
    private static final Character CHAR_FF = Character.valueOf('\f');
    private static final Character CHAR_BS = Character.valueOf('\b');
    private static final Character CHAR_NUL = Character.valueOf('\u0000');
    private static final Character CHAR_SOH = Character.valueOf('\u0001');
    private static final Character CHAR_STX = Character.valueOf('\u0002');
    private static final Character CHAR_ETX = Character.valueOf('\u0003');
    private static final Character CHAR_EOT = Character.valueOf('\u0004');
    private static final Character CHAR_ENQ = Character.valueOf('\u0005');
    private static final Character CHAR_ACK = Character.valueOf('\u0006');
    private static final Character CHAR_BEL = Character.valueOf('\u0007');

    public static Character resolveEscape(char c) {
        switch (c) {
            case '0': {
                return CHAR_NUL;
            }
            case 't': {
                return CHAR_TAB;
            }
            case '\\': {
                return CHAR_BACKSLASH;
            }
            case 'r': {
                return CHAR_CR;
            }
            case 'n': {
                return CHAR_LF;
            }
            case '\'': {
                return CHAR_SINGLE_QUOTE;
            }
            case '\"': {
                return CHAR_DOUBLE_QUOTE;
            }
            case 'f': {
                return CHAR_FF;
            }
            case 'b': {
                return CHAR_BS;
            }
            case '1': {
                return CHAR_SOH;
            }
            case '2': {
                return CHAR_STX;
            }
            case '3': {
                return CHAR_ETX;
            }
            case '4': {
                return CHAR_EOT;
            }
            case '5': {
                return CHAR_ENQ;
            }
            case '6': {
                return CHAR_ACK;
            }
            case '7': {
                return CHAR_BEL;
            }
        }
        return null;
    }

    public static Character resolveEscape(String sequence) {
        if (sequence == null) {
            return null;
        }
        int length = sequence.length();
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return CharEscapeHelper.resolveEscape(sequence.charAt(0));
        }
        if (length < 4) {
            for (int i = 0; i < length; ++i) {
                char c = sequence.charAt(i);
                if (c >= '0' && c <= '7') continue;
                return null;
            }
            int value = Integer.parseInt(sequence, 8);
            if (value <= 255) {
                return Character.valueOf((char)value);
            }
        } else if (length >= 5) {
            int start = length - 4;
            for (int i = start - 1; i >= 0; --i) {
                if (sequence.charAt(i) == 'u') continue;
                return null;
            }
            int value = Integer.parseInt(sequence.substring(start), 16);
            return Character.valueOf((char)value);
        }
        return null;
    }
}

