/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.lang.api;

import java.util.Locale;

public final class BasicHelper {
    static final Locale STANDARD_LOCALE = Locale.US;
    public static final String LINE_SEPARATOR = BasicHelper.getSystemProperty("line.separator");
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final String USER_HOME = BasicHelper.getSystemProperty("user.home").replace('\\', '/');
    private static final String USER_NAME = BasicHelper.getSystemProperty("user.name");

    private BasicHelper() {
    }

    public static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public static String toLowerCase(String string) {
        return string.toLowerCase(STANDARD_LOCALE);
    }

    public static String toLowerCase(String string, Locale locale) {
        if (locale == null) {
            return BasicHelper.toLowerCase(string, STANDARD_LOCALE);
        }
        return string.toLowerCase(locale);
    }

    public static String toUpperCase(String string) {
        return string.toUpperCase(STANDARD_LOCALE);
    }

    public static String toUpperCase(String string, Locale locale) {
        if (locale == null) {
            return BasicHelper.toUpperCase(string, STANDARD_LOCALE);
        }
        return string.toUpperCase(locale);
    }

    public static String getUserHomePath() {
        return USER_HOME;
    }

    public static String getUserLogin() {
        return USER_NAME;
    }
}

