/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mmm.util.date.base;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import net.sf.mmm.util.date.api.IllegalDateFormatException;
import net.sf.mmm.util.date.api.Iso8601Util;
import net.sf.mmm.util.date.base.Iso8601UtilLimitedImpl;
import net.sf.mmm.util.scanner.base.CharSequenceScanner;

public final class Iso8601UtilImpl
extends Iso8601UtilLimitedImpl
implements Iso8601Util {
    private static Iso8601UtilImpl instance;
    private static final String UTC_ID = "UTC";
    private static final TimeZone TZ_UTC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Iso8601UtilImpl getInstance() {
        if (instance != null) return instance;
        Class<Iso8601UtilImpl> clazz = Iso8601UtilImpl.class;
        synchronized (Iso8601UtilImpl.class) {
            if (instance != null) return instance;
            instance = new Iso8601UtilImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void formatDate(Date date, boolean extended, Appendable buffer) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.formatDate(calendar, extended, buffer);
    }

    @Override
    public String formatDate(Calendar calendar) {
        return this.formatDate(calendar, true);
    }

    @Override
    public String formatDate(Calendar calendar, boolean extended) {
        StringBuilder buffer = new StringBuilder(10);
        this.formatDate(calendar, extended, (Appendable)buffer);
        return buffer.toString();
    }

    @Override
    public void formatDate(Calendar calendar, boolean extended, Appendable buffer) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        this.formatDate(year, month, day, extended, buffer);
    }

    @Override
    public void formatDateTime(Date date, boolean extendedDate, boolean extendedTime, boolean extendedTimeZone, Appendable buffer) {
        try {
            Calendar calendar = Calendar.getInstance(TZ_UTC);
            calendar.setTime(date);
            this.formatDate(calendar, extendedDate, buffer);
            buffer.append('T');
            this.formatTime(calendar, extendedTime, buffer);
            buffer.append('Z');
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String formatDateTime(Calendar calendar) {
        return this.formatDateTime(calendar, true, true, true);
    }

    @Override
    public String formatDateTime(Calendar calendar, boolean extendedDate, boolean extendedTime, boolean extendedTimezone) {
        StringBuilder buffer = new StringBuilder(25);
        this.formatDateTime(calendar, extendedDate, extendedTime, extendedTimezone, (Appendable)buffer);
        return buffer.toString();
    }

    @Override
    public void formatDateTime(Calendar calendar, boolean extendedDate, boolean extendedTime, boolean extendedTimezone, Appendable buffer) {
        try {
            this.formatDate(calendar, extendedDate, buffer);
            buffer.append('T');
            this.formatTime(calendar, extendedTime, buffer);
            this.formatTimeZone(calendar, extendedTimezone, buffer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void formatTime(Calendar calendar, boolean extended, Appendable buffer) {
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        this.formatTime(hours, minutes, seconds, extended, buffer);
    }

    @Override
    public void formatTimeZone(Calendar calendar, boolean extended, Appendable buffer) {
        TimeZone timezone = calendar.getTimeZone();
        int timezoneOffset = timezone.getOffset(calendar.getTimeInMillis());
        this.formatTimeZone(timezoneOffset, extended, buffer);
    }

    @Override
    public Date parseDate(String date) {
        return this.parseCalendar(date).getTime();
    }

    @Override
    public Calendar parseCalendar(String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        this.parseCalendar(date, calendar);
        return calendar;
    }

    private TimeZone parseTimezone(CharSequenceScanner scanner) {
        int pos = scanner.getCurrentIndex();
        Integer offset = this.parseTimezoneOffset(scanner);
        if (offset != null) {
            int offsetMs = offset;
            String tzName = "GMT";
            if (offsetMs != 0) {
                tzName = offsetMs < 0 ? tzName + "-" : tzName + "+";
                tzName = tzName + scanner.substring(pos, scanner.getCurrentIndex());
            }
            return new SimpleTimeZone(offsetMs, tzName);
        }
        if (scanner.getCurrentIndex() == pos) {
            return null;
        }
        return TZ_UTC;
    }

    @Override
    public void parseCalendar(String date, Calendar calendar) {
        CharSequenceScanner scanner = new CharSequenceScanner(date);
        try {
            int[] ymd = this.parseDate(scanner);
            int year = ymd[0];
            int month = ymd[1];
            int day = ymd[2];
            char c = scanner.forceNext();
            if (c == 'T') {
                int[] hms = this.parseTime(scanner);
                int hour = hms[0];
                int minute = hms[1];
                int second = hms[2];
                TimeZone timeZone = this.parseTimezone(scanner);
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                }
                calendar.set(year, month - 1, day, hour, minute, second);
            } else if (c == '\u0000') {
                calendar.set(year, month - 1, day);
            } else {
                throw new IllegalArgumentException(scanner.toString());
            }
            calendar.set(14, 0);
        }
        catch (Exception e) {
            throw new IllegalDateFormatException(date, e);
        }
    }

    static {
        TZ_UTC = TimeZone.getTimeZone(UTC_ID);
    }
}

