/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpolatingVertexSizeTransformer<V>
implements Transformer<V, Integer> {
    protected double min;
    protected double max;
    protected Transformer<V, ? extends Number> values;
    protected int min_size;
    protected int size_diff;

    public InterpolatingVertexSizeTransformer(Transformer<V, ? extends Number> values, int min_size, int max_size) {
        if (min_size < 0 || max_size < 0) {
            throw new IllegalArgumentException("sizes must be non-negative");
        }
        if (min_size > max_size) {
            throw new IllegalArgumentException("min_size must be <= max_size");
        }
        this.min = 0.0;
        this.max = 0.0;
        this.values = values;
        this.setMinSize(min_size);
        this.setMaxSize(max_size);
    }

    public Integer transform(V v) {
        Number n = (Number)this.values.transform(v);
        double value = this.min;
        if (n != null) {
            value = n.doubleValue();
        }
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        if (this.min == this.max) {
            return this.min_size;
        }
        return this.min_size + (int)((value - this.min) / (this.max - this.min) * (double)this.size_diff);
    }

    public void setMinSize(int min_size) {
        this.min_size = min_size;
    }

    public void setMaxSize(int max_size) {
        this.size_diff = max_size - this.min_size;
    }
}

