/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import edu.uci.ics.jung.algorithms.generators.Lattice2DGenerator;
import edu.uci.ics.jung.algorithms.util.WeightedChoice;
import edu.uci.ics.jung.graph.Graph;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KleinbergSmallWorldGenerator<V, E>
extends Lattice2DGenerator<V, E> {
    private double clustering_exponent;
    private Random random;
    private static Map<Direction, Point2D> steps = new EnumMap<Direction, Point2D>(Direction.class);

    public KleinbergSmallWorldGenerator(Factory<Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int latticeSize, double clusteringExponent) {
        this(graph_factory, vertex_factory, edge_factory, latticeSize, latticeSize, clusteringExponent);
    }

    public KleinbergSmallWorldGenerator(Factory<Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int row_count, int col_count, double clusteringExponent) {
        super(graph_factory, vertex_factory, edge_factory, row_count, col_count, true);
        this.clustering_exponent = clusteringExponent;
        this.initialize();
    }

    public KleinbergSmallWorldGenerator(Factory<Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int row_count, int col_count, double clusteringExponent, boolean isToroidal) {
        super(graph_factory, vertex_factory, edge_factory, row_count, col_count, isToroidal);
        this.clustering_exponent = clusteringExponent;
        this.initialize();
    }

    private void initialize() {
        this.random = new Random();
        steps.put(Direction.UP, new Point2D.Float(0.0f, -1.0f));
        steps.put(Direction.DOWN, new Point2D.Float(0.0f, 1.0f));
        steps.put(Direction.LEFT, new Point2D.Float(-1.0f, 0.0f));
        steps.put(Direction.RIGHT, new Point2D.Float(1.0f, 0.0f));
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setRandomSeed(long seed) {
        this.random.setSeed(seed);
    }

    @Override
    public Graph<V, E> create() {
        Graph graph = super.create();
        int max_distance = this.is_toroidal ? (int)(Math.ceil((this.row_count - 1) / 2) + Math.ceil((this.col_count - 1) / 2)) : this.row_count - 1 + (this.col_count - 1);
        EnumMap<Direction, Boolean> direction_ok = new EnumMap<Direction, Boolean>(Direction.class);
        HashMap<Integer, Double> distance_weights = new HashMap<Integer, Double>();
        for (int i = 2; i <= max_distance; ++i) {
            distance_weights.put(i, Math.pow(i, -this.clustering_exponent));
        }
        WeightedChoice weighted_choice = new WeightedChoice(distance_weights);
        for (int i = 0; i < graph.getVertexCount(); ++i) {
            int row = this.getRow(i);
            int col = this.getCol(i);
            int max_distance_i = this.is_toroidal ? max_distance : Math.max(row, this.row_count - 1 - row) + Math.max(col, this.col_count - 1 - col);
            int distance_i = Integer.MAX_VALUE;
            while ((distance_i = ((Integer)weighted_choice.nextItem()).intValue()) < max_distance_i) {
            }
            Point2D.Float location = new Point2D.Float(row, col);
            Point2D.Float offset = new Point2D.Float(0.0f, 0.0f);
            if (this.is_toroidal) {
                for (Direction direction : Direction.values()) {
                    direction_ok.put(direction, true);
                }
            } else {
                boolean UL_OK = this.manhattanDistance(location, new Point2D.Float(0.0f, 0.0f)) >= distance_i;
                boolean UR_OK = this.manhattanDistance(location, new Point2D.Float(this.col_count - 1, 0.0f)) >= distance_i;
                boolean LL_OK = this.manhattanDistance(location, new Point2D.Float(0.0f, this.row_count - 1)) >= distance_i;
                boolean LR_OK = this.manhattanDistance(location, new Point2D.Float(this.col_count - 1, this.row_count - 1)) >= distance_i;
                direction_ok.put(Direction.UP, UL_OK || UR_OK);
                direction_ok.put(Direction.DOWN, LL_OK || LR_OK);
                direction_ok.put(Direction.LEFT, UL_OK || LL_OK);
                direction_ok.put(Direction.RIGHT, UR_OK || LR_OK);
            }
            for (int d = 1; d <= distance_i; ++d) {
                assert (this.walkAway(location, offset, direction_ok));
            }
            int j = this.getIndex((int)(((Point2D)location).getX() + ((Point2D)offset).getX() % (double)this.col_count), (int)(((Point2D)location).getY() + ((Point2D)offset).getY() % (double)this.row_count));
            Object source = this.getVertex(i);
            Object target = this.getVertex(j);
            graph.addEdge(this.edge_factory.create(), source, target);
        }
        return graph;
    }

    private boolean walkAway(Point2D current, Point2D offset, Map<Direction, Boolean> direction_ok) {
        ArrayList<Point2D> walk_candidates = new ArrayList<Point2D>(4);
        if (offset.getX() >= 0.0 && direction_ok.get((Object)Direction.RIGHT).booleanValue()) {
            this.addIfLegal(walk_candidates, current, this.sum(offset, steps.get((Object)Direction.RIGHT)));
        }
        if (offset.getX() <= 0.0 && direction_ok.get((Object)Direction.LEFT).booleanValue()) {
            this.addIfLegal(walk_candidates, current, this.sum(offset, steps.get((Object)Direction.LEFT)));
        }
        if (offset.getY() >= 0.0 && direction_ok.get((Object)Direction.DOWN).booleanValue()) {
            this.addIfLegal(walk_candidates, current, this.sum(offset, steps.get((Object)Direction.DOWN)));
        }
        if (offset.getY() <= 0.0 && direction_ok.get((Object)Direction.UP).booleanValue()) {
            this.addIfLegal(walk_candidates, current, this.sum(offset, steps.get((Object)Direction.UP)));
        }
        if (walk_candidates.isEmpty()) {
            return false;
        }
        Point2D step = (Point2D)walk_candidates.get(this.random.nextInt(walk_candidates.size()));
        offset.setLocation(this.sum(offset, step));
        current.setLocation(this.sum(current, step));
        return true;
    }

    private void addIfLegal(Collection<Point2D> locations, Point2D location, Point2D step) {
        Point2D new_location = this.sum(location, step);
        if (this.is_toroidal || new_location.getX() >= 0.0 && new_location.getX() < (double)this.col_count && new_location.getY() >= 0.0 && new_location.getY() < (double)this.row_count) {
            locations.add(step);
        }
    }

    private Point2D sum(Point2D p1, Point2D p2) {
        return new Point2D.Double(p1.getX() + p2.getX(), p1.getY() + p2.getY());
    }

    private int manhattanDistance(Point2D p1, Point2D p2) {
        return (int)(Math.abs(p1.getX() - p2.getX()) + Math.abs(p1.getY() - p2.getY()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

