/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import edu.uci.ics.jung.algorithms.generators.GraphGenerator;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EppsteinPowerLawGenerator<V, E>
implements GraphGenerator<V, E> {
    private int mNumVertices;
    private int mNumEdges;
    private int mNumIterations;
    private double mMaxDegree;
    private Random mRandom;
    private Factory<Graph<V, E>> graphFactory;
    private Factory<V> vertexFactory;
    private Factory<E> edgeFactory;

    public EppsteinPowerLawGenerator(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int numVertices, int numEdges, int r) {
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.mNumVertices = numVertices;
        this.mNumEdges = numEdges;
        this.mNumIterations = r;
        this.mRandom = new Random();
    }

    protected Graph<V, E> initializeGraph() {
        Graph graph = null;
        graph = (Graph)this.graphFactory.create();
        for (int i = 0; i < this.mNumVertices; ++i) {
            graph.addVertex(this.vertexFactory.create());
        }
        ArrayList vertices = new ArrayList(graph.getVertices());
        while (graph.getEdgeCount() < this.mNumEdges) {
            Object u = vertices.get((int)(this.mRandom.nextDouble() * (double)this.mNumVertices));
            Object v = vertices.get((int)(this.mRandom.nextDouble() * (double)this.mNumVertices));
            if (graph.isSuccessor(v, u)) continue;
            graph.addEdge(this.edgeFactory.create(), u, v);
        }
        double maxDegree = 0.0;
        for (Object v : graph.getVertices()) {
            maxDegree = Math.max((double)graph.degree(v), maxDegree);
        }
        this.mMaxDegree = maxDegree;
        return graph;
    }

    public Graph<V, E> create() {
        Graph<V, E> graph = this.initializeGraph();
        ArrayList vertices = new ArrayList(graph.getVertices());
        for (int rIdx = 0; rIdx < this.mNumIterations; ++rIdx) {
            Object v = null;
            int degree = 0;
            while ((degree = graph.degree(v = vertices.get((int)(this.mRandom.nextDouble() * (double)this.mNumVertices)))) == 0) {
            }
            ArrayList edges = new ArrayList(graph.getIncidentEdges(v));
            Object randomExistingEdge = edges.get((int)(this.mRandom.nextDouble() * (double)degree));
            Object x = vertices.get((int)(this.mRandom.nextDouble() * (double)this.mNumVertices));
            Object y = null;
            do {
                y = vertices.get((int)(this.mRandom.nextDouble() * (double)this.mNumVertices));
            } while (this.mRandom.nextDouble() > (double)(graph.degree(y) + 1) / this.mMaxDegree);
            if (graph.isSuccessor(y, x) || x == y) continue;
            graph.removeEdge(randomExistingEdge);
            graph.addEdge(this.edgeFactory.create(), x, y);
        }
        return graph;
    }

    public void setSeed(long seed) {
        this.mRandom.setSeed(seed);
    }
}

