/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.writer;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class CloseOnceWriter<T extends Writer>
extends FilterWriter {
    private int closeCount = 0;

    public CloseOnceWriter(T source) {
        super((Writer)source);
        if (source == null) {
            throw new IllegalArgumentException("Source Writer can't be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloseOnceWriter closeOnceWriter = this;
        synchronized (closeOnceWriter) {
            ++this.closeCount;
            if (this.closeCount > 1) {
                return;
            }
        }
        this.out.close();
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public T getWrappedWriter() {
        Writer result = this.out;
        return (T)result;
    }
}

