/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.utils;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class StreamUtils {
    private static final double ONE_THOUSAND = 1000.0;

    public static String getRateString(long bytes, long milliseconds) {
        return StreamUtils.getRateString(bytes, milliseconds, Locale.getDefault());
    }

    public static String getRateString(long bytes, long milliseconds, Locale locale) {
        String[] units = new String[]{"Byte", "KB", "MB", "GB"};
        double bytesSec = (double)bytes * 1000.0 / (double)milliseconds;
        double idx = Math.log(bytesSec) / Math.log(1024.0);
        int intIdx = Math.max(0, Math.min((int)Math.floor(idx), units.length - 1));
        double reducedRate = bytesSec / Math.pow(1024.0, intIdx);
        DecimalFormat df = new DecimalFormat();
        int ndigit = (int)Math.floor(Math.max(Math.log10(reducedRate), 0.0));
        df.setMinimumFractionDigits(0);
        df.setGroupingUsed(false);
        if (locale != null) {
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        }
        df.setMaximumFractionDigits(Math.max(0, 2 - ndigit));
        return df.format(reducedRate) + " " + units[intIdx] + "/sec";
    }

    public static byte[] read(InputStream source, int size) throws IOException {
        byte[] test = new byte[size];
        int n = StreamUtils.tryReadFully(source, test, 0, size);
        byte[] result = test;
        if (n < size) {
            if (n <= 0) {
                result = null;
            } else {
                result = new byte[n];
                System.arraycopy(test, 0, result, 0, n);
            }
        }
        return result;
    }

    public static int tryReadFully(InputStream source, byte[] buffer, int offset, int len) throws IOException {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len [" + len + "] < 0");
        }
        for (n = 0; n < len; n += count) {
            count = source.read(buffer, offset + n, len - n);
            if (count >= 0) continue;
            if (n != 0) break;
            n = count;
            break;
        }
        return n;
    }

    private StreamUtils() {
    }
}

