/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import com.gc.iotools.stream.utils.ArrayTools;
import com.gc.iotools.stream.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ChunkInputStream
extends InputStream {
    private final boolean automaticFetch;
    private boolean copyToOuter = false;
    private final boolean showMarkers;
    private final byte[] start;
    private final byte[] stop;
    private final InputStream wrappedIs;

    public ChunkInputStream(InputStream src, byte[] startMarker, byte[] stopMarker) {
        this(src, startMarker, stopMarker, false, startMarker != null && startMarker.length > 0);
    }

    public ChunkInputStream(InputStream src, byte[] startMarker, byte[] stopMarker, boolean showMarkers, boolean automaticFetch) {
        if (src == null) {
            throw new IllegalArgumentException("Wrapped InputStrem can't be null");
        }
        this.start = startMarker == null ? new byte[]{} : startMarker;
        this.stop = stopMarker == null ? new byte[]{} : stopMarker;
        this.wrappedIs = new BufferedInputStream(src);
        this.automaticFetch = automaticFetch;
        if (this.start.length == 0 && automaticFetch) {
            throw new IllegalArgumentException("It's not possible to specify a startMarker" + (startMarker == null ? "=null" : ".size=0") + " and" + " automaticFetch=[" + automaticFetch + "]");
        }
        this.showMarkers = showMarkers;
    }

    @Override
    public int available() throws IOException {
        this.findStartMarker();
        return this.wrappedIs.available();
    }

    @Override
    public void close() throws IOException {
        this.wrappedIs.close();
    }

    public boolean fetchNextChunk() throws IOException {
        if (this.automaticFetch) {
            throw new IllegalStateException("this method shouldn't be called when automaticFetch [" + this.automaticFetch + "]");
        }
        this.copyToOuter = this.moveToNextStartMarker();
        return this.copyToOuter;
    }

    private void findStartMarker() throws IOException {
        if (!this.copyToOuter && this.automaticFetch) {
            this.copyToOuter = this.moveToNextStartMarker();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedIs.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrappedIs.markSupported();
    }

    private boolean moveToNextStartMarker() throws IOException {
        boolean found;
        if (this.start.length == 0) {
            this.wrappedIs.mark(2);
            found = this.wrappedIs.read() >= 0;
            this.wrappedIs.reset();
        } else {
            int n;
            found = false;
            byte[] buffer = new byte[8192 + this.start.length];
            do {
                this.wrappedIs.mark(8192 + this.start.length);
                n = StreamUtils.tryReadFully(this.wrappedIs, buffer, 0, 8192 + this.start.length);
                if (n <= 0) continue;
                int pos = ArrayTools.indexOf(ArrayTools.subarray(buffer, 0, n), this.start);
                if (pos >= 0) {
                    found = true;
                    this.wrappedIs.reset();
                    int skip = pos + (this.showMarkers ? 0 : this.start.length);
                    this.wrappedIs.skip(skip);
                    continue;
                }
                if (n - this.start.length <= 0) continue;
                this.wrappedIs.reset();
                this.wrappedIs.skip(n - this.start.length);
            } while (!found && n >= 0);
        }
        return found;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int rd = this.read(buf);
        int result = buf[0];
        if (rd < 0) {
            result = rd;
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException("b.length[" + b.length + "] offset[" + off + "] length[" + len + "");
        }
        if (len == 0) {
            return 0;
        }
        this.findStartMarker();
        if (this.copyToOuter) {
            if (this.stop.length > 0) {
                int readSize = len - off + this.stop.length;
                byte[] tmpBuffer = new byte[readSize];
                this.wrappedIs.mark(readSize);
                ret = StreamUtils.tryReadFully(this.wrappedIs, tmpBuffer, 0, readSize);
                this.wrappedIs.reset();
                if (ret != -1) {
                    int position = ArrayTools.indexOf(tmpBuffer, this.stop);
                    if (position == -1) {
                        ret = Math.min(ret, len - off);
                        this.wrappedIs.skip(ret);
                        System.arraycopy(tmpBuffer, 0, b, off, ret);
                    } else if (position == 0) {
                        this.wrappedIs.skip(this.stop.length);
                        this.copyToOuter = false;
                        ret = this.read(b, off, len);
                    } else {
                        ret = position;
                        int bytesToSkip = position + this.stop.length;
                        this.wrappedIs.skip(bytesToSkip);
                        System.arraycopy(tmpBuffer, 0, b, off, position);
                        this.copyToOuter = false;
                    }
                }
            } else {
                ret = this.wrappedIs.read(b, off, len);
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedIs.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.findStartMarker();
        return super.skip(n);
    }
}

