/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Terms;

import ubc.cs.JLog.Foundation.jEquivalenceMapping;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jUnifiedVector;
import ubc.cs.JLog.Foundation.jVariableRegistry;
import ubc.cs.JLog.Foundation.jVariableVector;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jInteger;
import ubc.cs.JLog.Terms.jReal;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public abstract class jConjunctTerm
extends jTerm {
    protected jTerm lhs = null;
    protected jTerm rhs = null;

    protected jConjunctTerm(jTerm l, jTerm r) {
        this.lhs = l;
        this.rhs = r;
    }

    public jTerm getLHS() {
        return this.lhs;
    }

    public jTerm getRHS() {
        return this.rhs;
    }

    public void setLHS(jTerm l) {
        this.lhs = l;
    }

    public void setRHS(jTerm r) {
        this.rhs = r;
    }

    protected int compare(jTerm term, boolean first_call, boolean var_equal) {
        jTerm t = term.getTerm();
        if (t instanceof jVariable || t instanceof jReal || t instanceof jInteger) {
            return 1;
        }
        if (t instanceof iPredicate) {
            iPredicate ip = (iPredicate)t;
            int arity_b = ip.getArity();
            if (2 < arity_b) {
                return -1;
            }
            if (2 > arity_b) {
                return 1;
            }
            int compare_val = this.getName().compareTo(ip.getName());
            if (compare_val < 0) {
                return -1;
            }
            if (compare_val > 0) {
                return 1;
            }
            return 0;
        }
        if (t instanceof jConjunctTerm) {
            jTerm lt = ((jConjunctTerm)t).lhs;
            jTerm rt = ((jConjunctTerm)t).rhs;
            int compare_val = this.getName().compareTo(t.getName());
            if (compare_val < 0) {
                return -1;
            }
            if (compare_val > 0) {
                return 1;
            }
            int result = this.lhs.compare(lt, true, var_equal);
            if (result != 0) {
                return result;
            }
            return this.rhs.compare(rt, true, var_equal);
        }
        return first_call ? -t.compare(this, false, var_equal) : 0;
    }

    public boolean requiresCompleteVariableState() {
        return this.lhs.requiresCompleteVariableState() || this.rhs.requiresCompleteVariableState();
    }

    public void registerUnboundVariables(jUnifiedVector v) {
        this.lhs.registerUnboundVariables(v);
        this.rhs.registerUnboundVariables(v);
    }

    public boolean equivalence(jTerm term, jEquivalenceMapping v) {
        jTerm t = term.getTerm();
        if (this.type != t.type) {
            return false;
        }
        jConjunctTerm cterm = (jConjunctTerm)t;
        if (!this.lhs.equivalence(cterm.lhs, v)) {
            return false;
        }
        return this.rhs.equivalence(cterm.rhs, v);
    }

    public boolean unify(jTerm term, jUnifiedVector v) {
        if (term.type == 14) {
            return term.unify(this, v);
        }
        if (this.type != term.type) {
            return false;
        }
        jConjunctTerm cterm = (jConjunctTerm)term;
        if (!this.lhs.unify(cterm.lhs, v)) {
            return false;
        }
        return this.rhs.unify(cterm.rhs, v);
    }

    public void registerVariables(jVariableVector v) {
        this.lhs.registerVariables(v);
        this.rhs.registerVariables(v);
    }

    public void enumerateVariables(jVariableVector v, boolean all) {
        this.lhs.enumerateVariables(v, all);
        this.rhs.enumerateVariables(v, all);
    }

    public jTerm duplicate(jVariable[] vars) {
        return this.duplicate(this.lhs.duplicate(vars), this.rhs.duplicate(vars));
    }

    public jTerm copy(jVariableRegistry vars) {
        return this.duplicate(this.lhs.copy(vars), this.rhs.copy(vars));
    }

    protected abstract jConjunctTerm duplicate(jTerm var1, jTerm var2);

    public void consult(jKnowledgeBase kb) {
        this.lhs.consult(kb);
        this.rhs.consult(kb);
    }

    public void consultReset() {
        this.lhs.consultReset();
        this.rhs.consultReset();
    }
}

