/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Terms;

import java.util.Enumeration;
import java.util.Vector;
import ubc.cs.JLog.Foundation.jEquivalenceMapping;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jUnifiedVector;
import ubc.cs.JLog.Foundation.jVariableRegistry;
import ubc.cs.JLog.Foundation.jVariableVector;
import ubc.cs.JLog.Terms.iConsultable;
import ubc.cs.JLog.Terms.iMakeUnmake;
import ubc.cs.JLog.Terms.jCommand;
import ubc.cs.JLog.Terms.jCons;
import ubc.cs.JLog.Terms.jIf;
import ubc.cs.JLog.Terms.jOr;
import ubc.cs.JLog.Terms.jOrPredicate;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public class jCompoundTerm
extends jTerm
implements iMakeUnmake {
    protected Vector terms;

    public jCompoundTerm() {
        this.terms = new Vector();
        this.type = 5;
    }

    public jCompoundTerm(int initialCapacity) {
        this.terms = new Vector(initialCapacity);
        this.type = 5;
    }

    public jCompoundTerm(Vector t) {
        this.terms = t;
        this.type = 5;
    }

    public int compare(jTerm term, boolean first_call, boolean var_equal) {
        jTerm t = term.getTerm();
        if (t instanceof jCompoundTerm) {
            Vector vt = ((jCompoundTerm)t).terms;
            int max = this.terms.size();
            if (max < vt.size()) {
                return -1;
            }
            if (max > vt.size()) {
                return 1;
            }
            for (int i = 0; i < max; ++i) {
                int result = ((jTerm)this.terms.elementAt(i)).compare((jTerm)vt.elementAt(i), true, var_equal);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        return first_call ? -t.compare(this, false, var_equal) : 0;
    }

    public final boolean hasTerm(jTerm t) {
        return this.terms.indexOf(t) >= 0;
    }

    public void addTerm(jTerm t) {
        this.terms.addElement(t);
    }

    public void removeTerm(jTerm t) {
        this.terms.removeElement(t);
    }

    public void removeAllTerms() {
        this.terms.removeAllElements();
    }

    public final Enumeration enumTerms() {
        return this.terms.elements();
    }

    public final int size() {
        return this.terms.size();
    }

    public final jTerm elementAt(int index) {
        return (jTerm)this.terms.elementAt(index);
    }

    public void mutateElementAt(int index, jTerm term) {
        this.terms.setElementAt(term, index);
    }

    public final boolean isEmpty() {
        return this.terms.isEmpty();
    }

    public boolean requiresCompleteVariableState() {
        Enumeration e = this.terms.elements();
        while (e.hasMoreElements()) {
            if (!((jTerm)e.nextElement()).requiresCompleteVariableState()) continue;
            return true;
        }
        return false;
    }

    public void registerUnboundVariables(jUnifiedVector v) {
        int sz = this.terms.size();
        for (int i = 0; i < sz; ++i) {
            ((jTerm)this.terms.elementAt(i)).registerUnboundVariables(v);
        }
    }

    public boolean equivalence(jTerm term, jEquivalenceMapping v) {
        jTerm t = term.getTerm();
        if (this.type != t.type) {
            return false;
        }
        jCompoundTerm cterm = (jCompoundTerm)t;
        int sz = this.terms.size();
        if (sz != cterm.terms.size()) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (((jTerm)this.terms.elementAt(i)).equivalence((jTerm)cterm.terms.elementAt(i), v)) continue;
            return false;
        }
        return true;
    }

    public boolean unify(jTerm term, jUnifiedVector v) {
        if (term.type == 14) {
            return term.unify(this, v);
        }
        if (this.type != term.type) {
            return false;
        }
        jCompoundTerm cterm = (jCompoundTerm)term;
        int sz = this.terms.size();
        if (sz != cterm.terms.size()) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            if (((jTerm)this.terms.elementAt(i)).unify((jTerm)cterm.terms.elementAt(i), v)) continue;
            return false;
        }
        return true;
    }

    public void registerVariables(jVariableVector v) {
        Enumeration e = this.terms.elements();
        while (e.hasMoreElements()) {
            ((jTerm)e.nextElement()).registerVariables(v);
        }
    }

    public void enumerateVariables(jVariableVector v, boolean all) {
        Enumeration e = this.terms.elements();
        while (e.hasMoreElements()) {
            ((jTerm)e.nextElement()).enumerateVariables(v, all);
        }
    }

    public jTerm duplicate(jVariable[] vars) {
        return new jCompoundTerm(this.internal_duplicate(vars));
    }

    protected Vector internal_duplicate(jVariable[] vars) {
        int sz = this.terms.size();
        Vector<jTerm> t = new Vector<jTerm>(sz);
        for (int i = 0; i < sz; ++i) {
            t.addElement(((jTerm)this.terms.elementAt(i)).duplicate(vars));
        }
        return t;
    }

    public jTerm copy(jVariableRegistry vars) {
        return new jCompoundTerm(this.internal_copy(vars));
    }

    public Vector internal_copy(jVariableRegistry vars) {
        int sz = this.terms.size();
        Vector<jTerm> t = new Vector<jTerm>(sz);
        for (int i = 0; i < sz; ++i) {
            t.addElement(((jTerm)this.terms.elementAt(i)).copy(vars));
        }
        return t;
    }

    public void copyCompoundTerm(jCompoundTerm ct) {
        this.terms = (Vector)ct.terms.clone();
    }

    public void subtractCompoundTerm(jCompoundTerm ct) {
        Enumeration e = ct.terms.elements();
        while (e.hasMoreElements()) {
            this.removeTerm((jTerm)e.nextElement());
        }
    }

    public void unionCompoundTerm(jCompoundTerm ct) {
        Enumeration e = ct.terms.elements();
        while (e.hasMoreElements()) {
            jTerm t = (jTerm)e.nextElement();
            if (this.hasTerm(t)) continue;
            this.addTerm(t);
        }
    }

    public void intersectionCompoundTerm(jCompoundTerm ct) {
        Enumeration e = this.terms.elements();
        Vector<jTerm> vt = new Vector<jTerm>(Math.min(this.size(), ct.size()));
        while (e.hasMoreElements()) {
            jTerm t = (jTerm)e.nextElement();
            if (!ct.hasTerm(t)) continue;
            vt.addElement(t);
        }
        this.terms = vt;
    }

    public void make(jTerm t) {
        this.removeAllTerms();
        this.makeCompoundTerm(t);
    }

    public void makeCompoundTerm(jTerm t) {
        while (t instanceof jCons) {
            this.addTerm(((jCons)t).getLHS());
            t = ((jCons)t).getRHS().getTerm();
        }
        this.addTerm(t);
    }

    public jTerm unmake() {
        return this.unmakeCompoundTerm();
    }

    public synchronized jTerm unmakeCompoundTerm() {
        jTerm prev = null;
        for (int i = this.terms.size() - 1; i >= 0; --i) {
            prev = prev == null ? (jTerm)this.terms.elementAt(i) : new jCons((jTerm)this.terms.elementAt(i), prev);
        }
        return prev;
    }

    public void consult(jKnowledgeBase kb) {
        Enumeration e = this.enumTerms();
        while (e.hasMoreElements()) {
            ((iConsultable)e.nextElement()).consult(kb);
        }
    }

    public void consultReset() {
        Enumeration e = this.enumTerms();
        while (e.hasMoreElements()) {
            ((iConsultable)e.nextElement()).consultReset();
        }
    }

    public String toString(boolean usename) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Enumeration e = this.terms.elements();
        sb.append(this.getStartingSymbol());
        while (e.hasMoreElements()) {
            jTerm t;
            boolean higher_priority;
            if (!first) {
                sb.append(",");
            }
            boolean bl = higher_priority = this.isHigherPriorityOperator(t = (jTerm)e.nextElement()) && this.terms.size() > 1;
            if (higher_priority) {
                sb.append("(");
            }
            sb.append(t.toString(usename));
            if (higher_priority) {
                sb.append(")");
            }
            first = false;
        }
        sb.append(this.getEndingSymbol());
        return sb.toString();
    }

    protected String getStartingSymbol() {
        return "(";
    }

    protected String getEndingSymbol() {
        return ")";
    }

    protected boolean isHigherPriorityOperator(jTerm t) {
        return t instanceof jOr || t instanceof jOrPredicate || t instanceof jCommand || t instanceof jIf;
    }
}

