/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pCons;
import ubc.cs.JLog.Parser.pPacket;
import ubc.cs.JLog.Parser.pParens;
import ubc.cs.JLog.Parser.pPredicateEntry;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Parser.pTermToPacketHashtable;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Parser.pVariableRegistry;
import ubc.cs.JLog.Terms.InvalidPredicateNameException;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jCompoundTerm;
import ubc.cs.JLog.Terms.jPredicate;
import ubc.cs.JLog.Terms.jTerm;

class pPredicate
extends pPacket {
    protected pParens params = null;
    protected String name = null;
    protected pPredicateRegistry predicates;
    protected boolean generic_predicate = true;

    public pPredicate(pPredicateRegistry p, pToken pt) {
        super(pt);
        this.predicates = p;
    }

    public pPredicate(pPredicateRegistry p, String n, pToken pt) {
        super(pt);
        this.name = n;
        this.predicates = p;
    }

    public pPredicate(pPredicateRegistry p, pToken pt, pParens pp) {
        super(pt);
        this.params = pp;
        this.predicates = p;
    }

    public pPredicate(pPredicateRegistry p, String n, pToken pt, pParens pp) {
        super(pt);
        this.params = pp;
        this.name = n;
        this.predicates = p;
    }

    public String getName() {
        if (this.name == null) {
            return this.token.getToken();
        }
        return this.name;
    }

    public void setParameters(pParens pp) {
        this.params = pp;
    }

    public void setGeneric(boolean genericpred) {
        this.generic_predicate = genericpred;
        if (this.params != null) {
            this.params.setGeneric(false);
        }
    }

    public jTerm getTerm(pVariableRegistry vars, pTermToPacketHashtable phash) {
        jCompoundTerm cterm = this.params == null ? new jCompoundTerm(1) : this.makeCompoundTerm(new jCompoundTerm(), this.params.getInside(), vars, phash);
        try {
            iPredicate term = this.createSpecialPredicate(cterm);
            if (term == null) {
                term = !this.generic_predicate && cterm.size() == 0 ? new jAtom(this.getName()) : new jPredicate(this.getName(), cterm);
            }
            phash.putPacket(term, this);
            return term;
        }
        catch (InvalidPredicateNameException e) {
            throw new SyntaxErrorException("Valid name required for predicate at ", this.token.getPosition(), this.token.getLine(), this.token.getCharPos());
        }
    }

    protected iPredicate createSpecialPredicate(jCompoundTerm cterm) {
        pPredicateEntry pe;
        if (!this.generic_predicate && (pe = this.predicates.getPredicate(this.getName(), cterm.size())) != null) {
            return pe.createPredicate(this.token, cterm);
        }
        return null;
    }

    protected jCompoundTerm makeCompoundTerm(jCompoundTerm cterm, pPacket pp, pVariableRegistry vars, pTermToPacketHashtable phash) {
        if (pp instanceof pCons) {
            pCons ppc = (pCons)pp;
            cterm.addTerm(ppc.getLHS().getTerm(vars, phash));
            return this.makeCompoundTerm(cterm, ppc.getRHS(), vars, phash);
        }
        cterm.addTerm(pp.getTerm(vars, phash));
        return cterm;
    }
}

