/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import ubc.cs.JLog.Foundation.InvalidLibraryEntryException;
import ubc.cs.JLog.Parser.InvalidOperatorEntryException;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pPacket;
import ubc.cs.JLog.Parser.pTermToPacketHashtable;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Parser.pVariableRegistry;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jTerm;

public abstract class pOperatorEntry {
    public static final int FX = 1;
    public static final int FY = 2;
    public static final int XFX = 17;
    public static final int XFY = 18;
    public static final int YFX = 33;
    public static final int XF = 16;
    public static final int YF = 32;
    public static final int NON_ASSOCIATIVE = 0;
    public static final int LEFT_ASSOCIATIVE = 1;
    public static final int RIGHT_ASSOCIATIVE = 2;
    protected String name;
    protected int type;
    protected int priority;
    protected String library = null;

    public pOperatorEntry(String name, int type, int priority) {
        this.name = name;
        this.type = type;
        this.priority = priority;
        if (name == null || name.length() <= 0 || !this.isValidType() || priority < 0 || priority > 1200) {
            throw new InvalidOperatorEntryException();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasLHS() {
        return (this.type & 0xF0) != 0;
    }

    public boolean hasRHS() {
        return (this.type & 0xF) != 0;
    }

    public boolean isAtomPermitted() {
        return true;
    }

    public int getType() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getAssociativity() {
        if ((this.type & 0x20) == 32) {
            return 1;
        }
        if ((this.type & 2) == 2) {
            return 2;
        }
        return 0;
    }

    public boolean isNonAssociativeLeft() {
        return (this.type & 0x20) != 32;
    }

    public boolean isNonAssociativeRight() {
        return (this.type & 2) != 2;
    }

    public boolean isValidType() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 16: 
            case 17: 
            case 18: 
            case 32: 
            case 33: {
                return true;
            }
        }
        return false;
    }

    public void setLibrary(String lib) {
        if (this.library != null) {
            throw new InvalidLibraryEntryException();
        }
        this.library = lib;
    }

    public String getLibrary() {
        return this.library;
    }

    public boolean sameLibrary(String lib) {
        if (this.library == null && lib == null) {
            return true;
        }
        if (this.library == null || lib == null) {
            return false;
        }
        return this.library.equals(lib);
    }

    public jTerm createOperator(pToken pt, pPacket lhs, pPacket rhs, pVariableRegistry vars, pTermToPacketHashtable phash) {
        jTerm l = null;
        jTerm r = null;
        if (this.isAtomPermitted() && lhs == null && rhs == null) {
            return new jAtom(this.name);
        }
        if (this.hasLHS() && (lhs == null || (l = lhs.getTerm(vars, phash)) == null)) {
            throw new SyntaxErrorException("LHS term required before operator '" + this.getName() + "' at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
        }
        if (this.hasRHS() && (rhs == null || (r = rhs.getTerm(vars, phash)) == null)) {
            throw new SyntaxErrorException("RHS term required after operator '" + this.getName() + "' at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
        }
        return this.createOperator(l, r);
    }

    public abstract jTerm createOperator(jTerm var1, jTerm var2);

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append("(");
        switch (this.getType()) {
            case 1: {
                sb.append("FX");
                break;
            }
            case 2: {
                sb.append("FY");
                break;
            }
            case 17: {
                sb.append("XFX");
                break;
            }
            case 18: {
                sb.append("XFY");
                break;
            }
            case 33: {
                sb.append("YFX");
                break;
            }
            case 16: {
                sb.append("XF");
                break;
            }
            case 32: {
                sb.append("YF");
                break;
            }
            default: {
                sb.append("???");
            }
        }
        sb.append(",");
        sb.append(Integer.toString(this.getPriority()));
        sb.append(",");
        sb.append(this.isAtomPermitted() ? "atom allowed" : "atom *not* allowed");
        sb.append(")");
        String lib = this.getLibrary();
        if (lib != null) {
            sb.append(" library:" + lib);
        }
        return sb.toString();
    }
}

