/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import java.lang.reflect.Constructor;
import ubc.cs.JLog.Parser.InvalidGenericPredicateEntryException;
import ubc.cs.JLog.Parser.pPredicateEntry;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jCompoundTerm;
import ubc.cs.JLog.Terms.jTerm;

public class pGenericPredicateEntry
extends pPredicateEntry {
    protected static final Class[][] constructor_params_arrays = new Class[][]{new Class[0], {jTerm.class}, {jTerm.class, jTerm.class}, {jTerm.class, jTerm.class, jTerm.class}, {jTerm.class, jTerm.class, jTerm.class, jTerm.class}};
    protected Class predicate_class;

    public pGenericPredicateEntry(String name, int arity, String classname) {
        super(name, arity);
        if (arity < 0) {
            throw new InvalidGenericPredicateEntryException("Arity must be a fixed, positive value");
        }
        try {
            this.predicate_class = Class.forName(classname);
        }
        catch (Exception e) {
            throw new InvalidGenericPredicateEntryException("Predicate Class not found: " + classname);
        }
    }

    public pGenericPredicateEntry(String name, int arity, Class p_class) {
        super(name, arity);
        if (arity < 0) {
            throw new InvalidGenericPredicateEntryException("Arity must be a fixed, positive value");
        }
        this.predicate_class = p_class;
    }

    public iPredicate createPredicate(jCompoundTerm cterm) {
        try {
            Constructor pred_cons = null;
            iPredicate pred = null;
            pred_cons = this.predicate_class.getConstructor(this.getConstructorParamsArray());
            pred = (iPredicate)pred_cons.newInstance(this.getConstructorArgsArray(cterm));
            return pred;
        }
        catch (Exception e) {
            throw new InvalidGenericPredicateEntryException("Predicate construction failed");
        }
    }

    protected final Class[] getConstructorParamsArray() {
        if (this.arity >= 0 && this.arity <= 4) {
            return constructor_params_arrays[this.arity];
        }
        Class[] params = new Class[this.arity];
        for (int i = 0; i < this.arity; ++i) {
            params[i] = jTerm.class;
        }
        return params;
    }

    protected final Object[] getConstructorArgsArray(jCompoundTerm cterm) {
        Object[] args = new Object[this.arity];
        for (int i = 0; i < this.arity; ++i) {
            args[i] = cterm.elementAt(i);
        }
        return args;
    }
}

