/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import java.lang.reflect.Constructor;
import ubc.cs.JLog.Parser.InvalidGenericOperatorEntryException;
import ubc.cs.JLog.Parser.pOperatorEntry;
import ubc.cs.JLog.Terms.jTerm;

public class pGenericOperatorEntry
extends pOperatorEntry {
    protected static final Class[][] constructor_params_arrays = new Class[][]{{jTerm.class}, {jTerm.class, jTerm.class}};
    protected Class operator_class;
    protected boolean allow_atom = true;

    public pGenericOperatorEntry(String name, int type, int priority, String classname) {
        super(name, type, priority);
        try {
            this.operator_class = Class.forName(classname);
        }
        catch (Exception e) {
            throw new InvalidGenericOperatorEntryException("Operator Class not found: " + classname);
        }
    }

    public pGenericOperatorEntry(String name, int type, int priority, boolean aatom, String classname) {
        super(name, type, priority);
        this.allow_atom = aatom;
        try {
            this.operator_class = Class.forName(classname);
        }
        catch (Exception e) {
            throw new InvalidGenericOperatorEntryException("Operator Class not found");
        }
    }

    public pGenericOperatorEntry(String name, int type, int priority, Class op_class) {
        super(name, type, priority);
        this.operator_class = op_class;
    }

    public pGenericOperatorEntry(String name, int type, int priority, boolean aatom, Class op_class) {
        super(name, type, priority);
        this.allow_atom = aatom;
        this.operator_class = op_class;
    }

    public boolean isAtomPermitted() {
        return this.allow_atom;
    }

    public jTerm createOperator(jTerm l, jTerm r) {
        try {
            Constructor op_cons = null;
            jTerm op = null;
            op_cons = this.operator_class.getConstructor(this.getConstructorParamsArray());
            op = (jTerm)op_cons.newInstance(this.getConstructorArgsArray(l, r));
            return op;
        }
        catch (Exception e) {
            throw new InvalidGenericOperatorEntryException("Operator construction failed");
        }
    }

    protected final Class[] getConstructorParamsArray() {
        switch (this.type) {
            case 1: 
            case 2: 
            case 16: 
            case 32: {
                return constructor_params_arrays[0];
            }
            case 17: 
            case 18: 
            case 33: {
                return constructor_params_arrays[1];
            }
        }
        return null;
    }

    protected final Object[] getConstructorArgsArray(jTerm l, jTerm r) {
        switch (this.type) {
            case 1: 
            case 2: {
                return new Object[]{r};
            }
            case 16: 
            case 32: {
                return new Object[]{l};
            }
            case 17: 
            case 18: 
            case 33: {
                return new Object[]{l, r};
            }
        }
        return null;
    }
}

